/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModModels {
    public static DeferredObject<class_1087> milkJarLiquid;
    public static DeferredObject<class_1087> sinkLiquid;
    public static DeferredObject<class_1087> ovenDoor;
    public static DeferredObject<class_1087> ovenDoorHandle;
    public static DeferredObject<class_1087> ovenDoorActive;
    public static DeferredObject<class_1087> fridgeDoor;
    public static DeferredObject<class_1087> fridgeDoorFlipped;
    public static DeferredObject<class_1087> fridgeDoorLargeLower;
    public static DeferredObject<class_1087> fridgeDoorLargeUpper;
    public static DeferredObject<class_1087> fridgeDoorLargeLowerFlipped;
    public static DeferredObject<class_1087> fridgeDoorLargeUpperFlipped;
    public static List<DeferredObject<class_1087>> counterDoors;
    public static List<DeferredObject<class_1087>> counterDoorsFlipped;
    public static List<DeferredObject<class_1087>> cabinetDoors;
    public static List<DeferredObject<class_1087>> cabinetDoorsFlipped;

    public static void initialize(BalmModels models) {
        milkJarLiquid = models.loadModel(ModModels.id("block/milk_jar_liquid"));
        sinkLiquid = models.loadModel(ModModels.id("block/sink_liquid"));
        ovenDoor = models.loadModel(ModModels.id("block/oven_door"));
        ovenDoorHandle = models.loadModel(ModModels.id("block/oven_door_handle"));
        ovenDoorActive = models.loadModel(ModModels.id("block/oven_door_active"));
        fridgeDoor = models.loadModel(ModModels.id("block/fridge_door"));
        fridgeDoorFlipped = models.loadModel(ModModels.id("block/fridge_door_flipped"));
        fridgeDoorLargeLower = models.loadModel(ModModels.id("block/fridge_large_door_lower"));
        fridgeDoorLargeLowerFlipped = models.loadModel(ModModels.id("block/fridge_large_door_lower_flipped"));
        fridgeDoorLargeUpper = models.loadModel(ModModels.id("block/fridge_large_door_upper"));
        fridgeDoorLargeUpperFlipped = models.loadModel(ModModels.id("block/fridge_large_door_upper_flipped"));
        class_1767[] colors = class_1767.values();
        counterDoors = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        counterDoors.add(0, (DeferredObject<class_1087>)models.loadModel(ModModels.id("block/counter_door")));
        counterDoorsFlipped = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        counterDoorsFlipped.add(0, (DeferredObject<class_1087>)models.loadModel(ModModels.id("block/counter_door_flipped")));
        for (class_1767 color : colors) {
            counterDoors.add(color.method_7789() + 1, (DeferredObject<class_1087>)models.retexture(ModModels.id("block/counter_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
            counterDoorsFlipped.add(color.method_7789() + 1, (DeferredObject<class_1087>)models.retexture(ModModels.id("block/counter_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
        }
        cabinetDoors = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoors.add(0, (DeferredObject<class_1087>)models.loadModel(ModModels.id("block/cabinet_door")));
        cabinetDoorsFlipped = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoorsFlipped.add(0, (DeferredObject<class_1087>)models.loadModel(ModModels.id("block/cabinet_door_flipped")));
        for (class_1767 color : colors) {
            cabinetDoors.add(color.method_7789() + 1, (DeferredObject<class_1087>)models.retexture(ModModels.id("block/cabinet_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
            cabinetDoorsFlipped.add(color.method_7789() + 1, (DeferredObject<class_1087>)models.retexture(ModModels.id("block/cabinet_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
        }
        class_2960 sinkModel = ModModels.id("block/sink");
        class_2960 sinkFlippedModel = ModModels.id("block/sink_flipped");
        models.overrideModel(() -> ModBlocks.sink, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/sink"), it -> (Boolean)it.method_11654((class_2769)SinkBlock.FLIPPED) != false ? sinkFlippedModel : sinkModel, it -> {
            if (((Boolean)it.method_11654((class_2769)SinkBlock.HAS_COLOR)).booleanValue()) {
                return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((class_1767)it.method_11654((class_2769)SinkBlock.COLOR)));
            }
            return Collections.emptyMap();
        }, ModModels::lowerableFacingTransforms)).get());
        class_2960 toasterModel = ModModels.id("block/toaster");
        class_2960 toasterActiveModel = ModModels.id("block/toaster_active");
        models.overrideModel(() -> ModBlocks.toaster, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/toaster"), it -> (Boolean)it.method_11654((class_2769)ToasterBlock.ACTIVE) != false ? toasterActiveModel : toasterModel, null, ModModels::lowerableFacingTransforms)).get());
        class_2960 fridgeSmallModel = ModModels.id("block/fridge");
        class_2960 fridgeLargeLowerModel = ModModels.id("block/fridge_large_lower");
        class_2960 fridgeLargeUpperModel = ModModels.id("block/fridge_large_upper");
        models.overrideModel(() -> ModBlocks.fridge, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/fridge"), it -> {
            FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)((Object)it.method_11654(FridgeBlock.MODEL_TYPE)));
            return switch (fridgeModelType) {
                case FridgeBlock.FridgeModelType.LARGE_LOWER -> fridgeLargeLowerModel;
                case FridgeBlock.FridgeModelType.LARGE_UPPER -> fridgeLargeUpperModel;
                default -> fridgeSmallModel;
            };
        }, null, ModModels::lowerableFacingTransforms)).get());
        models.overrideModel(() -> ModBlocks.oven, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/oven"), null, state -> {
            boolean isActive;
            String normalTexture = "cookingforblockheads:block/oven_front";
            String activeTexture = "cookingforblockheads:block/oven_front_active";
            boolean isPowered = (Boolean)state.method_11654((class_2769)OvenBlock.POWERED);
            if (isPowered) {
                normalTexture = "cookingforblockheads:block/oven_front_powered";
                activeTexture = "cookingforblockheads:block/oven_front_powered_active";
            }
            if ((isActive = ((Boolean)state.method_11654((class_2769)OvenBlock.ACTIVE)).booleanValue()) || isPowered) {
                return ImmutableMap.of((Object)"ovenfront", (Object)(isActive ? activeTexture : normalTexture));
            }
            return Collections.emptyMap();
        }, ModModels::lowerableFacingTransforms)).get());
        models.overrideModel(() -> ModBlocks.cuttingBoard, () -> ModModels.createLowerableFacingModel("block/cutting_board").get());
        models.overrideModel(() -> ModBlocks.fruitBasket, () -> ModModels.createLowerableFacingModel("block/fruit_basket").get());
        models.overrideModel(() -> ModBlocks.milkJar, () -> ModModels.createLowerableFacingModel("block/milk_jar", List.of(class_1921.method_23581())).get());
        models.overrideModel(() -> ModBlocks.cowJar, () -> ModModels.createLowerableFacingModel("block/milk_jar", List.of(class_1921.method_23581())).get());
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.cookingTable, "block/cooking_table");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.counter, "block/counter");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.corner, "block/corner");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.hangingCorner, "block/hanging_corner");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.cabinet, "block/cabinet");
    }

    private static DeferredObject<class_1087> createLowerableFacingModel(String modelPath) {
        return ModModels.createLowerableFacingModel(modelPath, Collections.emptyList());
    }

    private static DeferredObject<class_1087> createLowerableFacingModel(String modelPath, List<class_1921> renderTypes) {
        return BalmClient.getModels().loadDynamicModel(ModModels.id(modelPath), null, null, ModModels::lowerableFacingTransforms, renderTypes);
    }

    private static void registerColoredKitchenBlock(BalmModels models, Supplier<class_2248> blockSupplier, String modelPath) {
        models.overrideModel(blockSupplier, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id(modelPath), null, it -> {
            if (((Boolean)it.method_11654((class_2769)BlockKitchen.HAS_COLOR)).booleanValue()) {
                return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((class_1767)it.method_11654(BlockKitchen.COLOR)));
            }
            return Collections.emptyMap();
        }, ModModels::lowerableFacingTransforms)).get());
    }

    private static class_2960 id(String path) {
        return new class_2960("cookingforblockheads", path);
    }

    private static ImmutableMap<String, String> replaceTexture(String texturePath) {
        return ImmutableMap.builder().put((Object)"texture", (Object)texturePath).put((Object)"particle", (Object)texturePath).build();
    }

    private static String getColoredTerracottaTexture(class_1767 color) {
        return "minecraft:block/" + color.name().toLowerCase(Locale.ENGLISH) + "_terracotta";
    }

    private static void lowerableFacingTransforms(class_2680 state, Matrix4f transform) {
        if (state.method_28498((class_2769)BlockKitchen.LOWERED) && ((Boolean)state.method_11654((class_2769)BlockKitchen.LOWERED)).booleanValue()) {
            transform.translate((Vector3fc)new Vector3f(0.0f, -0.05f, 0.0f));
        }
        if (state.method_28498((class_2769)BlockKitchen.FACING)) {
            float angle = ((class_2350)state.method_11654((class_2769)BlockKitchen.FACING)).method_10144();
            transform.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - angle));
        }
    }
}

