/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;

public class ItemListMessage {
    private final Collection<FoodRecipeWithStatus> recipeList;
    private final boolean hasOven;

    public ItemListMessage(Collection<FoodRecipeWithStatus> recipeList, boolean hasOven) {
        this.recipeList = recipeList;
        this.hasOven = hasOven;
    }

    public static void encode(ItemListMessage message, class_2540 buf) {
        int recipeCount = message.recipeList.size();
        buf.method_53002(recipeCount);
        for (FoodRecipeWithStatus recipe : message.recipeList) {
            ItemListMessage.writeRecipe(recipe, buf);
        }
        buf.method_52964(message.hasOven);
    }

    public static ItemListMessage decode(class_2540 buf) {
        int recipeCount = buf.readInt();
        ArrayList recipeList = Lists.newArrayListWithCapacity((int)recipeCount);
        for (int i = 0; i < recipeCount; ++i) {
            recipeList.add(ItemListMessage.readRecipe(buf));
        }
        boolean hasOven = buf.readBoolean();
        return new ItemListMessage(recipeList, hasOven);
    }

    public static void handle(class_1657 player, ItemListMessage message) {
        class_1703 container = player.field_7512;
        if (container instanceof RecipeBookMenu) {
            ((RecipeBookMenu)container).setItemList(message.recipeList);
            ((RecipeBookMenu)container).setHasOven(message.hasOven);
        }
    }

    private static FoodRecipeWithStatus readRecipe(class_2540 buf) {
        class_1799 outputItem = buf.method_10819();
        RecipeStatus status = RecipeStatus.fromId(buf.readByte());
        return new FoodRecipeWithStatus(outputItem, status);
    }

    private static void writeRecipe(FoodRecipeWithStatus recipe, class_2540 buf) {
        buf.method_10793(recipe.getOutputItem());
        buf.method_52997(recipe.getStatus().ordinal());
    }
}

