/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;

public class FoodRecipeWithIngredients {
    private final class_1799 outputItem;
    private final FoodRecipeType recipeType;
    private final RecipeStatus recipeStatus;
    private final int recipeWidth;
    private final List<class_2371<class_1799>> craftMatrix;
    private final int availabilityMap;

    public FoodRecipeWithIngredients(class_1799 outputItem, FoodRecipeType recipeType, RecipeStatus recipeStatus, int recipeWidth, List<class_2371<class_1799>> craftMatrix, int availabilityMap) {
        this.outputItem = outputItem;
        this.recipeType = recipeType;
        this.recipeStatus = recipeStatus;
        this.recipeWidth = recipeWidth;
        this.craftMatrix = craftMatrix;
        this.availabilityMap = availabilityMap;
    }

    public static FoodRecipeWithIngredients read(class_2540 buf) {
        class_1799 outputItem = buf.method_10819();
        byte recipeWidth = buf.readByte();
        int ingredientCount = buf.readByte();
        ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredientCount);
        for (int i = 0; i < ingredientCount; ++i) {
            int stackCount = buf.readByte();
            if (stackCount > 0) {
                class_2371 stackList = class_2371.method_10211();
                for (int j = 0; j < stackCount; ++j) {
                    stackList.add((Object)buf.method_10819());
                }
                craftMatrix.add(stackList);
                continue;
            }
            craftMatrix.add(null);
        }
        FoodRecipeType recipeType = FoodRecipeType.fromId(buf.readByte());
        RecipeStatus recipeStatus = RecipeStatus.fromId(buf.readByte());
        short availabilityMap = buf.readShort();
        return new FoodRecipeWithIngredients(outputItem, recipeType, recipeStatus, recipeWidth, craftMatrix, availabilityMap);
    }

    public void write(class_2540 buf) {
        buf.method_10793(this.outputItem);
        buf.method_52997(this.recipeWidth);
        buf.method_52997(this.craftMatrix.size());
        for (List list : this.craftMatrix) {
            buf.method_52997(list.size());
            for (class_1799 stack : list) {
                buf.method_10793(stack);
            }
        }
        buf.method_52997(this.recipeType.ordinal());
        buf.method_52997(this.recipeStatus.ordinal());
        buf.method_52998(this.availabilityMap);
    }

    public FoodRecipeType getRecipeType() {
        return this.recipeType;
    }

    public RecipeStatus getRecipeStatus() {
        return this.recipeStatus;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public List<class_2371<class_1799>> getCraftMatrix() {
        return this.craftMatrix;
    }

    public class_1799 getOutputItem() {
        return this.outputItem;
    }

    public static FoodRecipeWithIngredients fromFoodRecipe(FoodRecipe recipe, RecipeStatus status, List<class_2371<class_1799>> craftMatrix, int availabilityMap) {
        return new FoodRecipeWithIngredients(recipe.getOutputItem(), recipe.getType(), status, recipe.getRecipeWidth(), craftMatrix, availabilityMap);
    }

    public int getAvailabilityMap() {
        return this.availabilityMap;
    }
}

