/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import java.util.function.Supplier;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IMCHandler {
    public static final Logger logger = LogManager.getLogger();
    private static final NonNullList<ItemStack> imcNonFoodRecipes = NonNullList.create();

    private static <T> T getMessageData(InterModComms.IMCMessage message) {
        Supplier supplier = message.messageSupplier();
        return supplier.get();
    }

    public static void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            switch (message.method()) {
                case "RegisterTool": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addToolItem(itemStack);
                    break;
                }
                case "RegisterWaterItem": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addWaterItem(itemStack);
                    break;
                }
                case "RegisterMilkItem": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    CookingForBlockheadsAPI.addMilkItem(itemStack);
                    break;
                }
                case "RegisterToast": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.of((CompoundTag)tagCompound.getCompound("Input"));
                    ItemStack toastOutputItem = ItemStack.of((CompoundTag)tagCompound.getCompound("Output"));
                    if (!inputItem.isEmpty() && !toastOutputItem.isEmpty()) {
                        CookingForBlockheadsAPI.addToasterHandler(inputItem, it -> toastOutputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterToast expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterOvenFuel": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.of((CompoundTag)tagCompound.getCompound("Input"));
                    if (!inputItem.isEmpty() && tagCompound.contains("FuelValue", 99)) {
                        CookingForBlockheadsAPI.addOvenFuel(inputItem, tagCompound.getInt("FuelValue"));
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenFuel expected message of type NBT with structure {Input : ItemStack, FuelValue : numeric}");
                    break;
                }
                case "RegisterOvenRecipe": {
                    CompoundTag tagCompound = (CompoundTag)IMCHandler.getMessageData(message);
                    ItemStack inputItem = ItemStack.of((CompoundTag)tagCompound.getCompound("Input"));
                    ItemStack outputItem = ItemStack.of((CompoundTag)tagCompound.getCompound("Output"));
                    if (!inputItem.isEmpty() && !outputItem.isEmpty()) {
                        CookingForBlockheadsAPI.addOvenRecipe(inputItem, outputItem);
                        break;
                    }
                    CookingForBlockheads.logger.error("IMC API Error: RegisterOvenRecipe expected message of type NBT with structure {Input : ItemStack, Output : ItemStack}");
                    break;
                }
                case "RegisterNonFoodRecipe": {
                    ItemStack itemStack = (ItemStack)IMCHandler.getMessageData(message);
                    imcNonFoodRecipes.add((Object)itemStack);
                    break;
                }
                case "RegisterCowClass": {
                    String cowClassName = (String)IMCHandler.getMessageData(message);
                    try {
                        Class<?> clazz = Class.forName(cowClassName);
                        CookingForBlockheadsAPI.addCowClass(clazz);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        CookingForBlockheads.logger.error("Could not register cow class " + cowClassName + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : imcNonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }
}

