/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.api.capability;

import java.util.List;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractKitchenItemProvider
implements IKitchenItemProvider {
    @Override
    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        return ItemStack.EMPTY;
    }

    @Override
    public int getSlots() {
        return 0;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack returnItemStack(ItemStack itemStack) {
        return itemStack;
    }

    @Override
    public void resetSimulation() {
    }

    @Override
    public int getSimulatedUseCount(int slot) {
        return 0;
    }

    @Override
    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        for (int j = 0; j < this.getSlots(); ++j) {
            ItemStack itemStack = this.getStackInSlot(j);
            if (itemStack.isEmpty() || !predicate.test(itemStack, this.getCountInSlot(j) - this.getSimulatedUseCount(j))) continue;
            return new SourceItem(this, j, itemStack.copy());
        }
        return null;
    }

    @Override
    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        SourceItem sourceItem = this.findSource(predicate, maxAmount, inventories, requireBucket, simulate);
        if (sourceItem != null) {
            this.useItemStack(sourceItem.getSourceSlot(), Math.min(sourceItem.getSourceStack().getCount(), maxAmount), simulate, inventories, requireBucket);
        }
        return sourceItem;
    }

    @Override
    public void consumeSourceItem(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireContainer) {
        if (sourceItem.getSourceSlot() < 0) {
            return;
        }
        this.useItemStack(sourceItem.getSourceSlot(), maxAmount, false, inventories, requireContainer);
    }
}

