/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.tile.CabinetBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CabinetBlock
extends CounterBlock {
    private static final VoxelShape BOUNDING_BOX_NORTH = Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_EAST = Block.box((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WEST = Block.box((double)2.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_SOUTH = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);

    public CabinetBlock() {
        super(registryName);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> BOUNDING_BOX_EAST;
            case Direction.WEST -> BOUNDING_BOX_WEST;
            case Direction.SOUTH -> BOUNDING_BOX_SOUTH;
            default -> BOUNDING_BOX_NORTH;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? CabinetBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.cabinet.get()), CounterBlockEntity::clientTick) : CabinetBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.cabinet.get()), CounterBlockEntity::serverTick);
    }
}

