/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class OvenBlock
extends BlockKitchen {
    public static BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final String name = "oven";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "oven");
    private static final Random random = new Random();

    public OvenBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f, 10.0f), registryName);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, ACTIVE});
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == ModItems.heatingUnit) {
            return InteractionResult.PASS;
        }
        if (rayTraceResult.getDirection() == Direction.UP && CookingRegistry.isToolItem(heldItem)) {
            OvenBlockEntity tileOven;
            Direction stateFacing = (Direction)state.getValue((Property)FACING);
            double hx = rayTraceResult.getLocation().x;
            double hz = rayTraceResult.getLocation().z;
            switch (stateFacing) {
                case NORTH: {
                    hx = 1.0 - rayTraceResult.getLocation().x;
                    hz = 1.0 - rayTraceResult.getLocation().z;
                    break;
                }
                case WEST: {
                    hz = 1.0 - rayTraceResult.getLocation().x;
                    hx = rayTraceResult.getLocation().z;
                    break;
                }
                case EAST: {
                    hz = rayTraceResult.getLocation().x;
                    hx = 1.0 - rayTraceResult.getLocation().z;
                }
            }
            int index = -1;
            if (hx < 0.5 && hz < 0.5) {
                index = 1;
            } else if (hx >= 0.5 && hz < 0.5) {
                index = 0;
            } else if (hx < 0.5 && hz >= 0.5) {
                index = 3;
            } else if (hx >= 0.5 && hz >= 0.5) {
                index = 2;
            }
            if (index != -1 && (tileOven = (OvenBlockEntity)level.getBlockEntity(pos)) != null && tileOven.getToolItem(index).isEmpty()) {
                ItemStack toolItem = heldItem.split(1);
                tileOven.setToolItem(index, toolItem);
            }
            return InteractionResult.SUCCESS;
        }
        OvenBlockEntity oven = (OvenBlockEntity)level.getBlockEntity(pos);
        if (rayTraceResult.getDirection() == state.getValue((Property)FACING) && oven != null) {
            if (player.isShiftKeyDown()) {
                oven.getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && oven.getDoorAnimator().isForcedOpen()) {
                heldItem = ContainerUtils.insertItemStacked((Container)oven.getInputContainer(), (ItemStack)heldItem, (boolean)false);
                if (!heldItem.isEmpty()) {
                    heldItem = ContainerUtils.insertItemStacked((Container)oven.getFuelContainer(), (ItemStack)heldItem, (boolean)false);
                }
                player.setItemInHand(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)oven);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OvenBlockEntity(pos, state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        OvenBlockEntity tileEntity = (OvenBlockEntity)level.getBlockEntity(pos);
        if (tileEntity != null && tileEntity.isBurning()) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            float x = (float)pos.getX() + 0.5f;
            float y = (float)pos.getY() + 0.0f + OvenBlock.random.nextFloat() * 6.0f / 16.0f;
            float z = (float)pos.getZ() + 0.5f;
            float f3 = 0.52f;
            float f4 = OvenBlock.random.nextFloat() * 0.6f - 0.3f;
            if (facing == Direction.WEST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x - f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.EAST) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f3), (double)y, (double)(z + f4), 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f4), (double)y, (double)(z - f3), 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)(x + f4), (double)y, (double)(z + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (newState.getBlock() != state.getBlock() && (tileEntity = level.getBlockEntity(pos)) instanceof OvenBlockEntity && ((OvenBlockEntity)tileEntity).hasPowerUpgrade()) {
            ItemUtils.spawnItemStack(level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.heatingUnit));
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? OvenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::clientTick) : OvenBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.oven.get()), OvenBlockEntity::serverTick);
    }
}

