/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.tile.ToolRackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ToolRackBlock
extends BlockKitchen {
    public static final String name = "tool_rack";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "tool_rack");
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] RENDER_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.box((double)14.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0)};

    public ToolRackBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5f), registryName);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToolRackBlockEntity(pos, state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES[facing.get3DDataValue() - 2];
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return RENDER_SHAPES[facing.get3DDataValue() - 2];
    }

    public VoxelShape getCollisionShape(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return Shapes.empty();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace();
        if (facing == Direction.UP || facing == Direction.DOWN) {
            facing = Direction.NORTH;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof BlockItem) {
            return InteractionResult.SUCCESS;
        }
        Direction stateFacing = (Direction)state.getValue((Property)FACING);
        double hitX = rayTraceResult.getLocation().x - (double)pos.getX();
        double hitZ = rayTraceResult.getLocation().z - (double)pos.getZ();
        double hit = switch (stateFacing) {
            case Direction.NORTH -> hitX;
            case Direction.SOUTH -> 1.0 - hitX;
            case Direction.WEST -> 1.0 - hitZ;
            case Direction.EAST -> hitZ;
            default -> hitX;
        };
        int hitSlot = hit > 0.5 ? 0 : 1;
        ToolRackBlockEntity toolRack = (ToolRackBlockEntity)level.getBlockEntity(pos);
        if (toolRack != null) {
            if (!heldItem.isEmpty()) {
                ItemStack oldToolItem = toolRack.getContainer().getItem(hitSlot);
                ItemStack toolItem = heldItem.split(1);
                if (!oldToolItem.isEmpty()) {
                    if (!player.getInventory().add(oldToolItem)) {
                        player.drop(oldToolItem, false);
                    }
                    toolRack.getContainer().setItem(hitSlot, toolItem);
                } else {
                    toolRack.getContainer().setItem(hitSlot, toolItem);
                }
            } else {
                ItemStack itemStack = toolRack.getContainer().getItem(hitSlot);
                if (!itemStack.isEmpty()) {
                    toolRack.getContainer().setItem(hitSlot, ItemStack.EMPTY);
                    player.setItemInHand(hand, itemStack);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

