/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.gui.SortButton;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.RecipeFakeSlot;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RecipeBookScreen
extends AbstractContainerScreen<RecipeBookMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final RecipeBookMenu container;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private double mouseClickY = -1.0;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private Button btnNextRecipe;
    private Button btnPrevRecipe;
    private EditBox searchBar;
    private final List<SortButton> sortButtons = Lists.newArrayList();
    private final String[] noIngredients;
    private final String[] noSelection;

    public RecipeBookScreen(RecipeBookMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
        this.container = container;
        this.noIngredients = I18n.get((String)"gui.cookingforblockheads:no_ingredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = I18n.get((String)"gui.cookingforblockheads:no_selection", (Object[])new Object[0]).split("\\\\n");
    }

    protected void init() {
        this.imageHeight = 174;
        super.init();
        this.btnPrevRecipe = Button.builder((Component)Component.literal((String)"<"), it -> this.container.nextSubRecipe(-1)).pos(this.width / 2 - 79, this.height / 2 - 51).size(13, 20).build();
        this.btnPrevRecipe.visible = false;
        this.addRenderableWidget((GuiEventListener)this.btnPrevRecipe);
        this.btnNextRecipe = Button.builder((Component)Component.literal((String)">"), it -> this.container.nextSubRecipe(1)).pos(this.width / 2 - 9, this.height / 2 - 51).size(13, 20).build();
        this.btnNextRecipe.visible = false;
        this.addRenderableWidget((GuiEventListener)this.btnNextRecipe);
        this.searchBar = new EditBox(this.minecraft.font, this.leftPos + this.imageWidth - 78, this.topPos - 5, 70, 10, this.searchBar, (Component)Component.empty());
        this.setInitialFocus((GuiEventListener)this.searchBar);
        int yOffset = -80;
        for (ISortButton button : CookingRegistry.getSortButtons()) {
            SortButton sortButton = new SortButton(this.width / 2 + 87, this.height / 2 + yOffset, button, it -> this.container.setSortComparator(((SortButton)it).getComparator((Player)Minecraft.getInstance().player)));
            this.addRenderableWidget((GuiEventListener)sortButton);
            this.sortButtons.add(sortButton);
            yOffset += 20;
        }
        this.recalculateScrollBar();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY == 0.0) {
            return false;
        }
        if (this.container.getSelection() != null && mouseX >= (double)(this.leftPos + 7) && mouseY >= (double)(this.topPos + 17) && mouseX < (double)(this.leftPos + 92) && mouseY < (double)(this.topPos + 95)) {
            Slot slot = ((AbstractContainerScreenAccessor)this).getHoveredSlot();
            if (slot instanceof CraftMatrixFakeSlot && ((CraftMatrixFakeSlot)slot).getVisibleStacks().size() > 1) {
                ((CraftMatrixFakeSlot)slot).scrollDisplayList(deltaY > 0.0 ? -1 : 1);
            }
        } else {
            this.setCurrentOffset(deltaY > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        boolean result = super.mouseReleased(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return result;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot mouseSlot;
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && mouseX >= (double)this.searchBar.getX() && mouseX < (double)(this.searchBar.getX() + this.searchBar.getWidth()) && mouseY >= (double)this.searchBar.getY() && mouseY < (double)(this.searchBar.getY() + this.searchBar.getHeight())) {
            this.searchBar.setValue("");
            this.container.search(null);
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = ((AbstractContainerScreenAccessor)this).getHoveredSlot()) instanceof CraftMatrixFakeSlot) {
            if (button == 0) {
                ItemStack itemStack = mouseSlot.getItem();
                FoodRecipeWithStatus recipe = this.container.findAvailableRecipe(itemStack);
                if (recipe != null) {
                    this.container.setSelectedRecipe(recipe, false);
                    this.setCurrentOffset(this.container.getSelectedRecipeIndex());
                } else if (!CookingRegistry.getFoodRecipes(itemStack).isEmpty()) {
                    this.container.setSelectedRecipe(new FoodRecipeWithStatus(itemStack, RecipeStatus.MISSING_INGREDIENTS), true);
                }
            } else if (button == 1) {
                ((CraftMatrixFakeSlot)mouseSlot).setLocked(!((CraftMatrixFakeSlot)mouseSlot).isLocked());
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, int keyCode) {
        boolean result = super.charTyped(c, keyCode);
        this.container.search(this.searchBar.getValue());
        this.container.populateRecipeSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.isFocused()) {
            this.container.search(this.searchBar.getValue());
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int curY;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.setDirty(false);
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(guiTexture, this.leftPos, this.topPos - 10, 0, 0, this.imageWidth, this.imageHeight + 10);
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.visible = this.container.hasVariants();
        this.btnPrevRecipe.active = this.container.getSelectionIndex() > 0;
        this.btnNextRecipe.visible = this.container.hasVariants();
        this.btnNextRecipe.active = this.container.getSelectionIndex() < this.container.getRecipeCount() - 1;
        boolean hasRecipes = this.container.getItemListCount() > 0;
        for (Button button : this.sortButtons) {
            button.active = hasRecipes;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Font font = this.minecraft.font;
        FoodRecipeWithIngredients foodRecipeWithIngredients = this.container.getSelection();
        if (foodRecipeWithIngredients == null) {
            int n = this.noSelection.length / 2;
            Objects.requireNonNull(font);
            curY = this.topPos + 39 - n * 9;
            for (String s : this.noSelection) {
                guiGraphics.drawString(font, s, this.leftPos + 23 + 27 - font.width(s) / 2, curY, -1, true);
                Objects.requireNonNull(font);
                curY += 9 + 5;
            }
        } else if (foodRecipeWithIngredients.getRecipeType() == FoodRecipeType.SMELTING) {
            guiGraphics.blit(guiTexture, this.leftPos + 23, this.topPos + 19, 54, 184, 54, 54);
        } else {
            guiGraphics.blit(guiTexture, this.leftPos + 23, this.topPos + 19, 0, 184, 54, 54);
        }
        if (foodRecipeWithIngredients != null) {
            for (CraftMatrixFakeSlot slot : this.container.getCraftingMatrixSlots()) {
                if (!slot.isLocked() || slot.getVisibleStacks().size() <= 1) continue;
                guiGraphics.blit(guiTexture, this.leftPos + slot.x, this.topPos + slot.y, 176, 60, 16, 16);
            }
        }
        guiGraphics.fill(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
        if (this.container.getItemListCount() == 0) {
            guiGraphics.fill(this.leftPos + 97, this.topPos + 7, this.leftPos + 168, this.topPos + 85, -1440603614);
            int n = this.noIngredients.length / 2;
            Objects.requireNonNull(font);
            curY = this.topPos + 39 - n * 9;
            for (String s : this.noIngredients) {
                guiGraphics.drawString(font, s, this.leftPos + 97 + 36 - font.width(s) / 2, curY, -1, true);
                Objects.requireNonNull(font);
                curY += 9 + 5;
            }
        }
        this.searchBar.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (CookingForBlockheadsConfig.getActive().showIngredientIcon) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 300.0f);
            for (Slot slot : this.container.slots) {
                FoodRecipeWithStatus recipe;
                if (!(slot instanceof RecipeFakeSlot)) continue;
                if (CookingRegistry.isNonFoodRecipe(slot.getItem())) {
                    guiGraphics.blit(guiTexture, slot.x, slot.y, 176, 76, 16, 16);
                }
                if ((recipe = ((RecipeFakeSlot)slot).getRecipe()) == null || recipe.getStatus() != RecipeStatus.MISSING_TOOLS) continue;
                guiGraphics.blit(guiTexture, slot.x, slot.y, 176, 92, 16, 16);
            }
            poseStack.popPose();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 300.0f);
        for (Slot slot : this.container.slots) {
            if (!(slot instanceof CraftMatrixFakeSlot) || ((CraftMatrixFakeSlot)slot).isAvailable() || slot.getItem().isEmpty()) continue;
            guiGraphics.fillGradient(this.leftPos + slot.x, this.topPos + slot.y, this.leftPos + slot.x + 16, this.topPos + slot.y + 16, 0x77FF4444, 0x77FF5555);
        }
        poseStack.popPose();
        this.container.updateSlots(partialTicks);
        for (Button button : this.sortButtons) {
            if (!(button instanceof SortButton) || !button.isMouseOver((double)mouseX, (double)mouseY) || !button.active) continue;
            guiGraphics.renderTooltip(this.font, ((SortButton)button).getTooltipLines(), Optional.empty(), mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.leftPos + this.imageWidth - 7 - 9;
        this.scrollBarYPos = this.topPos + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public Button[] getSortingButtons() {
        return this.sortButtons.toArray(new SortButton[0]);
    }
}

