/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.Arrays;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemHandlerKitchenItemProvider
extends AbstractKitchenItemProvider {
    private IItemHandler itemHandler;
    private int[] usedStackSize;

    public ItemHandlerKitchenItemProvider() {
    }

    public ItemHandlerKitchenItemProvider(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    public void setItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    @Override
    public void resetSimulation() {
        Arrays.fill(this.usedStackSize, 0);
    }

    @Override
    public int getSimulatedUseCount(int slot) {
        return this.usedStackSize[slot];
    }

    @Override
    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (slot == -1) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.itemHandler.getStackInSlot(slot);
        if (itemStack.getCount() - (simulate ? this.usedStackSize[slot] : 0) >= amount) {
            ItemStack result = this.itemHandler.extractItem(slot, amount, simulate);
            if (simulate && !result.isEmpty()) {
                int n = slot;
                this.usedStackSize[n] = this.usedStackSize[n] + result.getCount();
            }
            return result;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
        ItemStack restStack = this.itemHandler.insertItem(sourceItem.getSourceSlot(), itemStack, false);
        if (!restStack.isEmpty()) {
            restStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)itemStack, (boolean)false);
        }
        return restStack;
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }
}

