/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.Optional;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.FoodStatsProvider;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class VanillaAddon
implements FoodStatsProvider {
    public VanillaAddon() {
        SinkHandler armorHandler = itemStack -> {
            if (itemStack.getItem() instanceof DyeableLeatherItem) {
                ((DyeableLeatherItem)itemStack.getItem()).clearColor(itemStack);
            }
            return itemStack;
        };
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.LEATHER_BOOTS), armorHandler);
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE), armorHandler);
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.LEATHER_HELMET), armorHandler);
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.LEATHER_LEGGINGS), armorHandler);
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.MILK_BUCKET), itemStack -> new ItemStack((ItemLike)Items.BUCKET));
        CookingForBlockheadsAPI.addSinkHandler(new ItemStack((ItemLike)Items.POTION), itemStack -> new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        CookingForBlockheadsAPI.setFoodStatsProvider(this);
    }

    @Override
    public float getSaturation(ItemStack itemStack, Player entityPlayer) {
        return Optional.ofNullable(itemStack.getItem().getFoodProperties()).map(FoodProperties::getSaturationModifier).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getFoodLevel(ItemStack itemStack, Player entityPlayer) {
        return Optional.ofNullable(itemStack.getItem().getFoodProperties()).map(FoodProperties::getNutrition).orElse(0);
    }
}

