/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.client.gui.screen.RecipeBookScreen;
import net.blay09.mods.cookingforblockheads.compat.jei.CowJarRecipe;
import net.blay09.mods.cookingforblockheads.compat.jei.CowJarRecipeCategory;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIAddon
implements IModPlugin {
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.cowJar), new RecipeType[]{CowJarRecipeCategory.TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (CookingForBlockheadsConfig.getActive().cowJarEnabled) {
            registration.addRecipes(CowJarRecipeCategory.TYPE, (List)ImmutableList.of((Object)new CowJarRecipe()));
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(RecipeBookScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<RecipeBookScreen>(){

            public List<Rect2i> getGuiExtraAreas(RecipeBookScreen containerScreen) {
                ArrayList list = Lists.newArrayList();
                for (Button button : containerScreen.getSortingButtons()) {
                    list.add(new Rect2i(button.getX(), button.getY(), button.getWidth(), button.getHeight()));
                }
                return list;
            }
        });
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("cookingforblockheads", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CowJarRecipeCategory(guiHelper)});
    }
}

