/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.compat.json.JsonCompatData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenFuelData;
import net.blay09.mods.cookingforblockheads.compat.json.OvenRecipeData;
import net.blay09.mods.cookingforblockheads.compat.json.ToasterRecipeData;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class JsonCompatLoader
implements ResourceManagerReloadListener {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    private static final FileToIdConverter COMPAT_FILES = FileToIdConverter.json((String)"cookingforblockheads/compat");
    public static final NonNullList<ItemStack> nonFoodRecipes = NonNullList.create();
    public static final Set<ResourceLocation> kitchenItemProviders = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> kitchenConnectors = new HashSet<ResourceLocation>();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        try {
            for (Map.Entry entry : COMPAT_FILES.listMatchingResources(resourceManager).entrySet()) {
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                    try {
                        JsonCompatLoader.load((JsonCompatData)gson.fromJson((Reader)reader, JsonCompatData.class));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    CookingForBlockheads.logger.error("Parsing error loading CookingForBlockheads data files at {}", entry.getKey(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            CookingForBlockheads.logger.error("Error loading CookingForBlockheads data files", (Throwable)e);
        }
    }

    public static void onCookingRegistry(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : nonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }

    private static void load(JsonCompatData data) {
        ItemStack output;
        ItemStack input;
        String modId = data.getModId();
        if (!modId.equals("minecraft") && !Balm.isModLoaded((String)modId)) {
            return;
        }
        if (data.getFoods() != null) {
            for (List<ResourceLocation> list : data.getFoods().values()) {
                for (ResourceLocation registryName : list) {
                    JsonCompatLoader.findItemStack(registryName).ifPresent(arg_0 -> nonFoodRecipes.add(arg_0));
                }
            }
        }
        if (data.getTools() != null) {
            for (ResourceLocation registryName : data.getTools()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addToolItem);
            }
        }
        if (data.getWater() != null) {
            for (ResourceLocation registryName : data.getWater()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addWaterItem);
            }
        }
        if (data.getMilk() != null) {
            for (ResourceLocation registryName : data.getMilk()) {
                JsonCompatLoader.findItemStack(registryName).ifPresent(CookingForBlockheadsAPI::addMilkItem);
            }
        }
        if (data.getOvenFuels() != null) {
            for (OvenFuelData ovenFuel : data.getOvenFuels()) {
                JsonCompatLoader.findItemStack(ovenFuel.getItem()).ifPresent(itemStack -> CookingForBlockheadsAPI.addOvenFuel(itemStack, ovenFuel.getValue()));
            }
        }
        if (data.getOvenRecipes() != null) {
            for (OvenRecipeData ovenRecipe : data.getOvenRecipes()) {
                input = JsonCompatLoader.findItemStack(ovenRecipe.getInput()).orElse(ItemStack.EMPTY);
                output = JsonCompatLoader.findItemStack(ovenRecipe.getOutput()).orElse(ItemStack.EMPTY);
                if (input.isEmpty() || output.isEmpty()) continue;
                CookingForBlockheadsAPI.addOvenRecipe(input, output);
            }
        }
        if (data.getToasterRecipes() != null) {
            for (ToasterRecipeData toasterRecipe : data.getToasterRecipes()) {
                input = JsonCompatLoader.findItemStack(toasterRecipe.getInput()).orElse(ItemStack.EMPTY);
                output = JsonCompatLoader.findItemStack(toasterRecipe.getOutput()).orElse(ItemStack.EMPTY);
                if (input.isEmpty() || output.isEmpty()) continue;
                CookingForBlockheadsAPI.addToasterHandler(input, itemStack -> output);
            }
        }
        if (data.getKitchenItemProviders() != null) {
            kitchenItemProviders.addAll(data.getKitchenItemProviders());
        }
        if (data.getKitchenConnectors() != null) {
            for (ResourceLocation kitchenConnector : data.getKitchenConnectors()) {
                kitchenConnectors.add(kitchenConnector);
                Block connectorBlock = Balm.getRegistries().getBlock(kitchenConnector);
                if (connectorBlock == null || connectorBlock == Blocks.AIR) continue;
                KitchenMultiBlock.registerConnectorBlock(connectorBlock);
            }
        }
    }

    private static Optional<ItemStack> findItemStack(ResourceLocation registryName) {
        Item item = Balm.getRegistries().getItem(registryName);
        return item == null || item == Items.AIR ? Optional.empty() : Optional.of(new ItemStack((ItemLike)item));
    }

    static {
        Balm.getEvents().onEvent(FoodRegistryInitEvent.class, JsonCompatLoader::onCookingRegistry);
    }
}

