/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeBook
extends Item {
    private final RecipeBookEdition edition;

    public ItemRecipeBook(RecipeBookEdition edition) {
        super(new Item.Properties().stacksTo(1));
        this.edition = edition;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            Balm.getNetworking().openGui(player, (MenuProvider)new BalmMenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)("cookingforblockheads:" + ItemRecipeBook.this.edition.getName()));
                }

                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    RecipeBookMenu container = new RecipeBookMenu(ItemRecipeBook.this.edition.getContainerTypeSupplier().get(), i, playerEntity);
                    if (ItemRecipeBook.this.edition == RecipeBookEdition.NO_FILTER) {
                        container.setNoFilter();
                    } else if (ItemRecipeBook.this.edition == RecipeBookEdition.CRAFTING) {
                        container.allowCrafting();
                    }
                    return container;
                }
            });
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(itemStack, level, tooltip, flag);
        String editionName = this.edition.getName();
        tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:" + editionName, ChatFormatting.YELLOW));
        for (String s : I18n.get((String)("tooltip.cookingforblockheads:" + editionName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextUtils.coloredTextComponent(s, ChatFormatting.GRAY));
        }
    }

    public static enum RecipeBookEdition {
        NO_FILTER("no_filter_edition", () -> (MenuType)ModMenus.noFilterBook.get()),
        RECIPE("recipe_book", () -> (MenuType)ModMenus.recipeBook.get()),
        CRAFTING("crafting_book", () -> (MenuType)ModMenus.craftingBook.get());

        private final String name;
        private final Supplier<MenuType<RecipeBookMenu>> containerTypeSupplier;

        private RecipeBookEdition(String name, Supplier<MenuType<RecipeBookMenu>> containerTypeSupplier) {
            this.name = name;
            this.containerTypeSupplier = containerTypeSupplier;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<MenuType<RecipeBookMenu>> getContainerTypeSupplier() {
            return this.containerTypeSupplier;
        }
    }
}

