/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import net.blay09.mods.cookingforblockheads.menu.IContainerWithDoor;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.blay09.mods.cookingforblockheads.menu.slot.OvenResultSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.SlotOven;
import net.blay09.mods.cookingforblockheads.menu.slot.SlotOvenFuel;
import net.blay09.mods.cookingforblockheads.menu.slot.SlotOvenTool;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OvenMenu
extends AbstractContainerMenu
implements IContainerWithDoor {
    private final OvenBlockEntity tileEntity;

    public OvenMenu(int windowId, Inventory playerInventory, OvenBlockEntity oven) {
        super((MenuType)ModMenus.oven.get(), windowId);
        int j;
        int i;
        this.tileEntity = oven;
        Container container = oven.getInternalContainer();
        int offsetX = oven.hasPowerUpgrade() ? -5 : 0;
        for (i = 0; i < 3; ++i) {
            this.addSlot(new Slot(container, i, 84 + i * 18 + offsetX, 19));
        }
        this.addSlot(new SlotOvenFuel(container, 3, 61 + offsetX, 59));
        for (i = 0; i < 3; ++i) {
            this.addSlot(new OvenResultSlot(playerInventory.player, oven, container, i + 4, 142 + offsetX, 41 + i * 18));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new SlotOven(container, 7 + j + i * 3, 84 + j * 18 + offsetX, 41 + i * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.addSlot(new SlotOvenTool(container, 16 + i, 8, 19 + i * 18, i));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 30 + j * 18, 111 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 30 + i * 18, 169));
        }
        oven.getDoorAnimator().openContainer(playerInventory.player);
        this.addDataSlots(oven.getContainerData());
    }

    public OvenBlockEntity getTileEntity() {
        return this.tileEntity;
    }

    public void removed(Player player) {
        super.removed(player);
        this.tileEntity.getDoorAnimator().closeContainer(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex >= 7 && slotIndex < 20) {
                if (!this.moveItemStackTo(slotStack, 20, 56, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotIndex >= 4 && slotIndex <= 6) {
                if (!this.moveItemStackTo(slotStack, 20, 56, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, itemStack);
            } else if (slotIndex >= 20) {
                ItemStack smeltingResult = this.tileEntity.getSmeltingResult(slotStack);
                if (OvenBlockEntity.isItemFuel(slotStack) ? !this.moveItemStackTo(slotStack, 3, 4, false) : (!smeltingResult.isEmpty() ? !this.moveItemStackTo(slotStack, 0, 3, false) : (slotIndex >= 20 && slotIndex < 47 ? !this.moveItemStackTo(slotStack, 47, 56, false) : slotIndex >= 47 && slotIndex < 56 && !this.moveItemStackTo(slotStack, 20, 47, false)))) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(slotStack, 20, 47, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    @Override
    public boolean isTileEntity(BlockEntity blockEntity) {
        return this.tileEntity == blockEntity;
    }
}

