/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.menu.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.FakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.RecipeFakeSlot;
import net.blay09.mods.cookingforblockheads.network.message.CraftRecipeMessage;
import net.blay09.mods.cookingforblockheads.network.message.ItemListMessage;
import net.blay09.mods.cookingforblockheads.network.message.RecipesMessage;
import net.blay09.mods.cookingforblockheads.network.message.RequestRecipesMessage;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class RecipeBookMenu
extends AbstractContainerMenu {
    private final Player player;
    private final List<RecipeFakeSlot> recipeSlots = Lists.newArrayList();
    private final List<CraftMatrixFakeSlot> matrixSlots = Lists.newArrayList();
    private final InventoryCraftBook craftBook = new InventoryCraftBook(this);
    private boolean noFilter;
    private boolean allowCrafting;
    private KitchenMultiBlock multiBlock;
    private boolean isDirty = true;
    private ItemStack lastOutputItem = ItemStack.EMPTY;
    private final List<FoodRecipeWithStatus> itemList = Lists.newArrayList();
    private Comparator<FoodRecipeWithStatus> currentSorting = new ComparatorName();
    private final List<FoodRecipeWithStatus> filteredItems = Lists.newArrayList();
    private boolean slotWasClicked;
    private String currentSearch;
    private boolean isDirtyClient;
    private boolean hasOven;
    private int scrollOffset;
    private FoodRecipeWithStatus selectedRecipe;
    private List<FoodRecipeWithIngredients> selectedRecipeList;
    private int selectedRecipeIndex;
    private boolean isInNoFilterPreview;

    public RecipeBookMenu(MenuType<RecipeBookMenu> containerType, int windowId, Player player) {
        super(containerType, windowId);
        FakeSlot slot;
        int j;
        int i;
        this.player = player;
        DefaultContainer fakeInventory = new DefaultContainer(21);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new RecipeFakeSlot((Container)fakeInventory, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.recipeSlots.add((RecipeFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                slot = new CraftMatrixFakeSlot((Container)fakeInventory, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.matrixSlots.add((CraftMatrixFakeSlot)slot);
                this.addSlot(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, 8 + i * 18, 150));
        }
    }

    public void clicked(int slotNumber, int dragType, ClickType clickType, Player player) {
        this.slotWasClicked = true;
        if (slotNumber >= 0 && slotNumber < this.slots.size()) {
            Slot slot = (Slot)this.slots.get(slotNumber);
            if (player.level().isClientSide && slot instanceof RecipeFakeSlot) {
                RecipeFakeSlot recipeSlot = (RecipeFakeSlot)slot;
                if (this.selectedRecipe != null && recipeSlot.getRecipe() == this.selectedRecipe) {
                    FoodRecipeWithIngredients recipe;
                    if (this.allowCrafting && (clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP) && (recipe = this.getSelection()) != null) {
                        NonNullList craftMatrix = NonNullList.create();
                        if (recipe.getRecipeType() == FoodRecipeType.CRAFTING) {
                            for (CraftMatrixFakeSlot matrixSlot : this.matrixSlots) {
                                craftMatrix.add((Object)matrixSlot.getItem());
                            }
                        } else if (recipe.getRecipeType() == FoodRecipeType.SMELTING) {
                            craftMatrix.add((Object)this.matrixSlots.get(4).getItem());
                        }
                        Balm.getNetworking().sendToServer((Object)new CraftRecipeMessage(recipe.getOutputItem(), recipe.getRecipeType(), (NonNullList<ItemStack>)craftMatrix, clickType == ClickType.QUICK_MOVE));
                    }
                } else {
                    this.setSelectedRecipe(recipeSlot.getRecipe(), false);
                }
            }
        }
        super.clicked(slotNumber, dragType, clickType, player);
    }

    public void setSelectedRecipe(@Nullable FoodRecipeWithStatus recipe, boolean forceNoFilter) {
        this.selectedRecipe = recipe;
        if (this.selectedRecipe != null) {
            Balm.getNetworking().sendToServer((Object)new RequestRecipesMessage(this.selectedRecipe.getOutputItem(), forceNoFilter));
        }
        this.isInNoFilterPreview = forceNoFilter;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.level().isClientSide && (this.isDirty || this.slotWasClicked)) {
            this.findAndSendItemList();
            if (!this.lastOutputItem.isEmpty()) {
                this.findAndSendRecipes(this.lastOutputItem, this.isInNoFilterPreview);
            }
            this.slotWasClicked = false;
            this.isDirty = false;
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void slotsChanged(Container inventory) {
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotIndex >= 48 && slotIndex < 57 ? !this.moveItemStackTo(slotStack, 21, 48, true) : slotIndex >= 21 && slotIndex < 48 && !this.moveItemStackTo(slotStack, 48, 57, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public RecipeBookMenu setNoFilter() {
        this.noFilter = true;
        return this;
    }

    public RecipeBookMenu allowCrafting() {
        this.allowCrafting = true;
        return this;
    }

    public RecipeBookMenu setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.multiBlock = kitchenMultiBlock;
        return this;
    }

    public void findAndSendItemList() {
        HashMap statusMap = Maps.newHashMap();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.getInventory());
        block0: for (ResourceLocation key : CookingRegistry.getFoodRecipes().keySet()) {
            Enum bestStatus = null;
            for (FoodRecipe recipe : CookingRegistry.getFoodRecipes().get((Object)key)) {
                RecipeStatus thisStatus = CookingRegistry.getRecipeStatus(recipe, inventories, this.multiBlock != null && this.multiBlock.hasSmeltingProvider());
                if (!(!this.noFilter && thisStatus == RecipeStatus.MISSING_INGREDIENTS || bestStatus != null && thisStatus.ordinal() <= bestStatus.ordinal())) {
                    statusMap.put(key, new FoodRecipeWithStatus(recipe.getOutputItem(), thisStatus));
                    bestStatus = thisStatus;
                }
                if (bestStatus != RecipeStatus.AVAILABLE) continue;
                continue block0;
            }
        }
        Balm.getNetworking().sendTo(this.player, (Object)new ItemListMessage(statusMap.values(), this.multiBlock != null && this.multiBlock.hasSmeltingProvider()));
    }

    public void findAndSendRecipes(ItemStack outputItem, boolean forceNoFilter) {
        this.lastOutputItem = outputItem;
        this.isInNoFilterPreview = forceNoFilter;
        ArrayList resultList = Lists.newArrayList();
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(this.multiBlock, this.player.getInventory());
        block0: for (FoodRecipe recipe : CookingRegistry.getFoodRecipes(outputItem)) {
            for (IKitchenItemProvider itemProvider : inventories) {
                itemProvider.resetSimulation();
            }
            List<FoodIngredient> ingredients = recipe.getCraftMatrix();
            ArrayList craftMatrix = Lists.newArrayListWithCapacity((int)ingredients.size());
            boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
            int availabilityMap = 0;
            for (int i = 0; i < ingredients.size(); ++i) {
                FoodIngredient ingredient = ingredients.get(i);
                NonNullList stackList = NonNullList.create();
                if (ingredient != null) {
                    List<SourceItem> sourceList = CookingRegistry.findSourceCandidates(ingredient, inventories, requireBucket, this.noFilter || forceNoFilter);
                    if (sourceList.isEmpty()) continue block0;
                    if (sourceList.stream().anyMatch(it -> it.getSourceProvider() != null)) {
                        int origX = i % 3;
                        int origY = i / 3;
                        int targetIdx = origY * 3 + origX;
                        availabilityMap |= 1 << targetIdx;
                    }
                    for (SourceItem source : sourceList) {
                        ItemStack foundStack = source.getSourceStack();
                        stackList.add((Object)(foundStack.getCount() > 127 ? ContainerUtils.copyStackWithSize((ItemStack)foundStack, (int)127) : foundStack));
                    }
                }
                craftMatrix.add(stackList);
            }
            RecipeStatus recipeStatus = CookingRegistry.getRecipeStatus(recipe, inventories, this.multiBlock != null && this.multiBlock.hasSmeltingProvider());
            resultList.add(FoodRecipeWithIngredients.fromFoodRecipe(recipe, recipeStatus, craftMatrix, availabilityMap));
        }
        resultList.sort((o1, o2) -> o2.getRecipeStatus().ordinal() - o1.getRecipeStatus().ordinal());
        Balm.getNetworking().sendTo(this.player, (Object)new RecipesMessage(outputItem, resultList));
    }

    public void tryCraft(ItemStack outputItem, FoodRecipeType recipeType, NonNullList<ItemStack> craftMatrix, boolean stack) {
        if (outputItem.isEmpty() || craftMatrix.size() == 0) {
            return;
        }
        if (this.allowCrafting) {
            if (recipeType == FoodRecipeType.CRAFTING) {
                ItemStack itemStack;
                int craftCount = stack ? outputItem.getMaxStackSize() / outputItem.getCount() : 1;
                for (int i = 0; i < craftCount && !(itemStack = this.craftBook.tryCraft(outputItem, craftMatrix, this.player, this.multiBlock)).isEmpty(); ++i) {
                    if (this.player.getInventory().add(itemStack)) continue;
                    this.player.drop(itemStack, false);
                }
                this.isDirty = true;
                this.broadcastChanges();
            } else if (recipeType == FoodRecipeType.SMELTING && this.multiBlock != null && this.multiBlock.hasSmeltingProvider()) {
                this.multiBlock.trySmelt(outputItem, (ItemStack)craftMatrix.get(0), this.player, stack);
                this.isDirty = true;
            }
        }
    }

    public boolean isAllowCrafting() {
        return this.allowCrafting;
    }

    public void setItemList(Collection<FoodRecipeWithStatus> recipeList) {
        this.itemList.clear();
        this.itemList.addAll(recipeList);
        int previousSelectionIndex = this.selectedRecipe != null ? this.filteredItems.indexOf(this.selectedRecipe) : -1;
        this.search(this.currentSearch);
        this.filteredItems.sort(this.currentSorting);
        if (this.selectedRecipe != null && previousSelectionIndex != -1) {
            Iterator<FoodRecipeWithStatus> it = this.filteredItems.iterator();
            FoodRecipeWithStatus found = null;
            while (it.hasNext()) {
                FoodRecipeWithStatus recipe = it.next();
                if (!ItemStack.isSameItem((ItemStack)recipe.getOutputItem(), (ItemStack)this.selectedRecipe.getOutputItem())) continue;
                found = recipe;
                it.remove();
                break;
            }
            while (previousSelectionIndex > this.filteredItems.size()) {
                this.filteredItems.add(null);
            }
            this.filteredItems.add(previousSelectionIndex, found);
            this.selectedRecipe = found;
        }
        this.populateRecipeSlots();
        this.setDirty(true);
    }

    public void populateRecipeSlots() {
        int i = this.scrollOffset * 3;
        for (RecipeFakeSlot slot : this.recipeSlots) {
            if (i < this.filteredItems.size()) {
                slot.setFoodRecipe(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setFoodRecipe(null);
        }
    }

    private void populateMatrixSlots() {
        FoodRecipeWithIngredients recipe = this.selectedRecipeList != null ? this.selectedRecipeList.get(this.selectedRecipeIndex) : null;
        this.populateMatrixSlots(recipe);
    }

    public void populateMatrixSlots(@Nullable FoodRecipeWithIngredients recipe) {
        if (recipe == null) {
            for (CraftMatrixFakeSlot matrixSlot : this.matrixSlots) {
                matrixSlot.setIngredient(null);
                matrixSlot.setAvailable(true);
            }
            return;
        }
        if (recipe.getRecipeType() == FoodRecipeType.SMELTING) {
            for (int i = 0; i < this.matrixSlots.size(); ++i) {
                this.matrixSlots.get(i).setIngredient(i == 4 ? recipe.getCraftMatrix().get(0) : null);
                this.matrixSlots.get(i).setAvailable((recipe.getAvailabilityMap() & 1) == 1);
            }
        } else {
            int i;
            List<NonNullList<ItemStack>> ingredients = recipe.getCraftMatrix();
            NonNullList[] matrix = new NonNullList[9];
            boolean[] availableMatrix = new boolean[9];
            for (i = 0; i < ingredients.size(); ++i) {
                NonNullList<ItemStack> ingredient = ingredients.get(i);
                int matrixSlot = this.mapToMatrixSlot(recipe, i);
                matrix[matrixSlot] = ingredient;
                availableMatrix[matrixSlot] = (recipe.getAvailabilityMap() & 1 << i) == 1 << i;
            }
            for (i = 0; i < this.matrixSlots.size(); ++i) {
                CraftMatrixFakeSlot matrixSlot = this.matrixSlots.get(i);
                matrixSlot.setIngredient((NonNullList<ItemStack>)(matrix[i] != null ? matrix[i] : NonNullList.create()));
                matrixSlot.setAvailable(availableMatrix[i]);
            }
        }
    }

    private int mapToMatrixSlot(FoodRecipeWithIngredients recipe, int ingredientIndex) {
        int recipeWidth = recipe.getRecipeWidth();
        int origX = ingredientIndex % recipeWidth;
        int origY = ingredientIndex / recipeWidth;
        int offsetX = recipeWidth == 1 ? 1 : 0;
        return origY * 3 + origX + offsetX;
    }

    public void setSortComparator(Comparator<FoodRecipeWithStatus> comparator) {
        this.currentSorting = comparator;
        this.filteredItems.removeIf(Objects::isNull);
        this.filteredItems.sort(comparator);
        this.populateRecipeSlots();
    }

    public int getItemListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateRecipeSlots();
    }

    public void search(@Nullable String term) {
        this.scrollOffset = 0;
        this.currentSearch = term;
        this.filteredItems.clear();
        if (term == null || term.trim().isEmpty()) {
            this.filteredItems.addAll(this.itemList);
        } else {
            block0: for (FoodRecipeWithStatus recipe : this.itemList) {
                if (recipe.getOutputItem().getDisplayName().getString().toLowerCase(Locale.ENGLISH).contains(term.toLowerCase())) {
                    this.filteredItems.add(recipe);
                    continue;
                }
                List tooltips = recipe.getOutputItem().getTooltipLines(this.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
                for (Component tooltip : tooltips) {
                    if (!tooltip.getString().toLowerCase(Locale.ENGLISH).contains(term.toLowerCase())) continue;
                    this.filteredItems.add(recipe);
                    continue block0;
                }
            }
        }
        this.filteredItems.sort(this.currentSorting);
    }

    @Nullable
    public FoodRecipeWithIngredients getSelection() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.get(this.selectedRecipeIndex) : null;
    }

    public boolean isSelectedSlot(RecipeFakeSlot slot) {
        return slot.getRecipe() == this.selectedRecipe;
    }

    public boolean isDirty() {
        return this.isDirtyClient;
    }

    public void setDirty(boolean dirty) {
        this.isDirtyClient = dirty;
    }

    public void setHasOven(boolean hasOven) {
        this.hasOven = hasOven;
    }

    public boolean hasOven() {
        return this.hasOven;
    }

    public void setRecipeList(ItemStack outputItem, List<FoodRecipeWithIngredients> recipeList) {
        List<FoodRecipeWithIngredients> list = this.selectedRecipeList = recipeList.size() > 0 ? recipeList : null;
        if (this.lastOutputItem.isEmpty() || this.lastOutputItem.getItem() != outputItem.getItem() || this.selectedRecipeList == null || this.selectedRecipeIndex >= this.selectedRecipeList.size()) {
            this.selectedRecipeIndex = 0;
        }
        this.populateMatrixSlots();
        this.lastOutputItem = outputItem;
    }

    public void nextSubRecipe(int i) {
        if (this.selectedRecipeList != null) {
            this.selectedRecipeIndex = Math.max(0, Math.min(this.selectedRecipeList.size() - 1, this.selectedRecipeIndex + i));
            this.populateMatrixSlots();
        }
    }

    public boolean hasVariants() {
        return this.selectedRecipeList != null && this.selectedRecipeList.size() > 1;
    }

    public void updateSlots(float partialTicks) {
        for (CraftMatrixFakeSlot slot : this.matrixSlots) {
            slot.updateSlot(partialTicks);
        }
    }

    public int getSelectionIndex() {
        return this.selectedRecipeIndex;
    }

    public int getRecipeCount() {
        return this.selectedRecipeList != null ? this.selectedRecipeList.size() : 0;
    }

    public List<CraftMatrixFakeSlot> getCraftingMatrixSlots() {
        return this.matrixSlots;
    }

    @Nullable
    public FoodRecipeWithStatus findAvailableRecipe(ItemStack itemStack) {
        return this.itemList.stream().filter(it -> ItemStack.isSameItem((ItemStack)it.getOutputItem(), (ItemStack)itemStack)).findAny().orElse(null);
    }

    public int getSelectedRecipeIndex() {
        return this.filteredItems.indexOf(this.selectedRecipe);
    }
}

