/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.comparator;

import java.util.Comparator;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.menu.comparator.ComparatorName;
import net.minecraft.world.entity.player.Player;

public class ComparatorHunger
implements Comparator<FoodRecipeWithStatus> {
    private final ComparatorName fallback = new ComparatorName();
    private final Player player;

    public ComparatorHunger(Player player) {
        this.player = player;
    }

    @Override
    public int compare(FoodRecipeWithStatus o1, FoodRecipeWithStatus o2) {
        boolean isFirstFood = o1.getOutputItem().getItem().isEdible();
        boolean isSecondFood = o2.getOutputItem().getItem().isEdible();
        if (!isFirstFood && !isSecondFood) {
            return this.fallback.compare(o1, o2);
        }
        if (!isFirstFood) {
            return 1;
        }
        if (!isSecondFood) {
            return -1;
        }
        int result = CookingForBlockheadsAPI.getFoodStatsProvider().getFoodLevel(o2.getOutputItem(), this.player) - CookingForBlockheadsAPI.getFoodStatsProvider().getFoodLevel(o1.getOutputItem(), this.player);
        if (result == 0) {
            return this.fallback.compare(o1, o2);
        }
        return result;
    }
}

