/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.inventory;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class InventoryCraftBook
extends TransientCraftingContainer
implements RecipeCraftingHolder {
    private RecipeHolder<?> recipeUsed;

    public InventoryCraftBook(AbstractContainerMenu menu) {
        super(menu, 3, 3);
    }

    public ItemStack tryCraft(ItemStack outputItem, NonNullList<ItemStack> craftMatrix, Player player, KitchenMultiBlock multiBlock) {
        int i;
        boolean requireContainer = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(multiBlock, player.getInventory());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        SourceItem[] sourceItems = new SourceItem[9];
        block1: for (i = 0; i < craftMatrix.size(); ++i) {
            ItemStack ingredient = (ItemStack)craftMatrix.get(i);
            if (ingredient.isEmpty()) continue;
            IngredientPredicateWithCache ingredientPredicate = IngredientPredicateWithCacheImpl.of((it, count) -> ItemStack.isSameItem((ItemStack)it, (ItemStack)ingredient) && count > 0, ingredient);
            for (int j = 0; j < inventories.size(); ++j) {
                IKitchenItemProvider itemProvider = inventories.get(j);
                SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(ingredientPredicate, 1, inventories, requireContainer, true);
                if (sourceItem == null) continue;
                sourceItems[i] = sourceItem;
                continue block1;
            }
        }
        for (i = 0; i < sourceItems.length; ++i) {
            this.setItem(i, sourceItems[i] != null ? sourceItems[i].getSourceStack() : ItemStack.EMPTY);
        }
        Level level = player.level();
        CraftingRecipe craftingRecipe = (CraftingRecipe)CookingRegistry.findFoodRecipe(this, level, RecipeType.CRAFTING, outputItem.getItem());
        if (craftingRecipe == null || craftingRecipe.getResultItem(level.registryAccess()).isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!craftingRecipe.matches((Container)this, level)) {
            return ItemStack.EMPTY;
        }
        ItemStack result = craftingRecipe.assemble((Container)this, level.registryAccess());
        if (!result.isEmpty()) {
            this.fireEventsAndHandleAchievements(player, result);
            for (int i2 = 0; i2 < this.getContainerSize(); ++i2) {
                ItemStack restStack;
                IKitchenItemProvider sourceProvider;
                ItemStack itemStack = this.getItem(i2);
                if (itemStack.isEmpty() || sourceItems[i2] == null || (sourceProvider = sourceItems[i2].getSourceProvider()) == null) continue;
                ItemStack containerItem = Balm.getHooks().getCraftingRemainingItem(itemStack);
                if (sourceItems[i2].getSourceSlot() != -1) {
                    sourceProvider.resetSimulation();
                    sourceProvider.consumeSourceItem(sourceItems[i2], 1, inventories, requireContainer);
                }
                if (containerItem.isEmpty() || (restStack = sourceProvider.returnItemStack(containerItem, sourceItems[i2])).isEmpty() || player.getInventory().add(restStack)) continue;
                ItemEntity itemEntity = new ItemEntity(level, player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, restStack);
                float motion = 0.05f;
                itemEntity.setDeltaMovement(level.random.nextGaussian() * (double)motion, level.random.nextGaussian() * (double)motion + 0.2, level.random.nextGaussian() * (double)motion);
                level.addFreshEntity((Entity)itemEntity);
            }
        }
        return result;
    }

    private void fireEventsAndHandleAchievements(Player player, ItemStack result) {
        result.onCraftedBy(player.level(), player, 1);
        Balm.getHooks().firePlayerCraftingEvent(player, result, (Container)this);
        this.awardUsedRecipes(player, this.getItems());
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        this.recipeUsed = recipe;
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return this.recipeUsed;
    }
}

