/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu.slot;

import net.blay09.mods.cookingforblockheads.menu.slot.FakeSlot;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CraftMatrixFakeSlot
extends FakeSlot {
    private static final float ITEM_SWITCH_TIME = 80.0f;
    private final NonNullList<ItemStack> visibleStacks = NonNullList.create();
    private float visibleItemTime;
    private int visibleItemIndex;
    private boolean isLocked;
    private boolean available = true;

    public CraftMatrixFakeSlot(Container container, int slotId, int x, int y) {
        super(container, slotId, x, y);
    }

    public void setIngredient(@Nullable NonNullList<ItemStack> ingredients) {
        ItemStack prevLockStack = this.isLocked ? this.getItem() : ItemStack.EMPTY;
        this.visibleStacks.clear();
        if (ingredients != null) {
            for (ItemStack itemStack : ingredients) {
                if (itemStack.isEmpty()) continue;
                itemStack.setCount(1);
                this.visibleStacks.add((Object)itemStack);
            }
        }
        this.visibleItemTime = 0.0f;
        this.visibleItemIndex = !this.visibleStacks.isEmpty() ? this.index % this.visibleStacks.size() : 0;
        this.isLocked = false;
        if (!prevLockStack.isEmpty()) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)((ItemStack)this.visibleStacks.get(i)), (ItemStack)prevLockStack)) continue;
                this.visibleItemIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.visibleItemTime += partialTicks;
            if (this.visibleItemTime >= 80.0f) {
                ++this.visibleItemIndex;
                if (this.visibleItemIndex >= this.visibleStacks.size()) {
                    this.visibleItemIndex = 0;
                }
                this.visibleItemTime = 0.0f;
            }
        }
    }

    @Override
    public ItemStack getItem() {
        return this.visibleStacks.size() > 0 ? (ItemStack)this.visibleStacks.get(this.visibleItemIndex) : ItemStack.EMPTY;
    }

    @Override
    public boolean hasItem() {
        return this.visibleStacks.size() > 0;
    }

    public boolean isActive() {
        return this.visibleStacks.size() > 0;
    }

    public NonNullList<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void scrollDisplayList(int i) {
        this.isLocked = true;
        this.visibleItemIndex += i;
        if (this.visibleItemIndex >= this.visibleStacks.size()) {
            this.visibleItemIndex = 0;
        } else if (this.visibleItemIndex < 0) {
            this.visibleItemIndex = this.visibleStacks.size() - 1;
        }
    }
}

