/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CounterBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final int containerSize;
    private final DefaultContainer container;
    private final DefaultKitchenItemProvider itemProvider;
    private final DoorAnimator doorAnimator;
    private Component customName;
    private boolean isDirty;
    private DyeColor color;

    public CounterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.counter.get(), pos, state);
    }

    public CounterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.containerSize = CookingForBlockheadsConfig.getActive().largeCounters ? 54 : 27;
        this.container = new DefaultContainer(this.containerSize){

            public void setChanged() {
                CounterBlockEntity.this.setChanged();
            }
        };
        this.itemProvider = new DefaultKitchenItemProvider((Container)this.container);
        this.doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
        this.color = DyeColor.WHITE;
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(SoundEvents.CHEST_OPEN);
        this.doorAnimator.setSoundEventClose(SoundEvents.CHEST_CLOSE);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        CompoundTag itemHandlerCompound = tag.getCompound("ItemHandler");
        if (CookingForBlockheadsConfig.getActive().largeCounters && itemHandlerCompound.getInt("Size") < 54) {
            itemHandlerCompound.putInt("Size", 54);
        }
        this.container.deserialize(itemHandlerCompound);
        this.color = DyeColor.byId((int)tag.getByte("Color"));
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
        if (tag.contains("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.getBoolean("IsForcedOpen"));
        }
        if (tag.contains("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.getByte("NumPlayersUsing"));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("ItemHandler", (Tag)this.container.serialize());
        tag.putByte("Color", (byte)this.color.getId());
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
        tag.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Direction getFacing() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)blockState.getValue((Property)BlockStateProperties.FACING) : Direction.NORTH;
    }

    public boolean isFlipped() {
        BlockState blockState = this.getBlockState();
        return blockState.hasProperty((Property)CounterBlock.FLIPPED) && (Boolean)blockState.getValue((Property)CounterBlock.FLIPPED) != false;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new CounterMenu(i, playerInventory, this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1), this.worldPosition.offset(2, 1, 2));
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.counter");
    }

    public void setChanged() {
        this.isDirty = true;
        super.setChanged();
    }

    public Container getContainer() {
        return this.container;
    }
}

