/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfigData;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CowJarBlockEntity
extends MilkJarBlockEntity
implements IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private Component customName;
    private boolean compressedCow;

    public CowJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends MilkJarBlockEntity>)((BlockEntityType)ModBlockEntities.cowJar.get()), pos, state);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
        this.compressedCow = tag.getBoolean("CompressedCow");
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
        tag.putBoolean("CompressedCow", this.compressedCow);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.milkTank.getAmount() < 32000) {
            CookingForBlockheadsConfigData config = CookingForBlockheadsConfig.getActive();
            int milkToAdd = config.cowJarMilkPerTick;
            if (this.compressedCow) {
                milkToAdd = (int)((double)milkToAdd * config.compressedCowJarMilkMultiplier);
            }
            this.milkTank.fill(Compat.getMilkFluid(), milkToAdd, false);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public Component getDefaultName() {
        if (this.compressedCow) {
            return Component.translatable((String)"container.cookingforblockheads.cow_jar_compressed");
        }
        return Component.translatable((String)"container.cookingforblockheads.cow_jar");
    }
}

