/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final DefaultContainer container = new DefaultContainer(27){

        public void setChanged() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.setChanged();
        }
    };
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)this.container){
        private final ItemStack snowStack;
        private final ItemStack iceStack;
        {
            this.snowStack = new ItemStack((ItemLike)Items.SNOWBALL);
            this.iceStack = new ItemStack((ItemLike)Blocks.ICE);
        }

        @Nullable
        private SourceItem applyIceUnit(IngredientPredicate predicate, int maxAmount) {
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.snowStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((ItemStack)this.snowStack, (int)maxAmount));
            }
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.iceStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((ItemStack)this.iceStack, (int)maxAmount));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).isEmpty() || CookingRegistry.isToolItem(it));
            }
            return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }

        @Override
        @Nullable
        public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).isEmpty() || CookingRegistry.isToolItem(it));
            }
            return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    private Component customName;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.fridgeClose.get());
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean triggerEvent(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.triggerEvent(id, type);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.container.deserialize(tag.getCompound("ItemHandler"));
        this.hasIceUpgrade = tag.getBoolean("HasIceUpgrade");
        this.hasPreservationUpgrade = tag.getBoolean("HasPreservationUpgrade");
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
        if (tag.contains("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.getBoolean("IsForcedOpen"));
        }
        if (tag.contains("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.getByte("NumPlayersUsing"));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("ItemHandler", (Tag)this.container.serialize());
        tag.putBoolean("HasIceUpgrade", this.hasIceUpgrade);
        tag.putBoolean("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
        tag.putBoolean("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.putByte("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        if (this.level.getBlockState(this.worldPosition.above()).getBlock() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.level.getBlockEntity(this.worldPosition.above());
        }
        if (this.level.getBlockState(this.worldPosition.below()).getBlock() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.level.getBlockEntity(this.worldPosition.below());
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.hasLevel()) {
            return this;
        }
        if (this.level.getBlockState(this.worldPosition.below()).getBlock() instanceof FridgeBlock && (baseFridge = (FridgeBlockEntity)this.level.getBlockEntity(this.worldPosition.below())) != null) {
            return baseFridge;
        }
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Container getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new Container[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition.offset(-1, 0, -1), this.worldPosition.offset(2, 2, 2));
    }

    public void markDirtyAndUpdate() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.fridge");
    }

    public Container getContainer() {
        return this.container;
    }
}

