/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.menu.SpiceRackMenu;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SpiceRackBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider {
    private final DefaultContainer container = new DefaultContainer(9){

        public void setChanged() {
            SpiceRackBlockEntity.this.setChanged();
        }
    };
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)this.container);
    private Component customName;
    private boolean isDirty;

    public SpiceRackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.spiceRack.get(), pos, state);
    }

    public void load(CompoundTag tagCompound) {
        super.load(tagCompound);
        this.container.deserialize(tagCompound.getCompound("ItemHandler"));
        if (tagCompound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tagCompound.getString("CustomName"));
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("ItemHandler", (Tag)this.container.serialize());
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new SpiceRackMenu(i, playerInventory, this);
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.cookingforblockheads.spice_rack");
    }

    public Container getContainer() {
        return this.container;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SpiceRackBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public void setChanged() {
        this.isDirty = true;
        super.setChanged();
    }
}

