/*
 * Decompiled with CFR 0.152.
 */
package io.github.daomephsta.dangersense;

import io.github.daomephsta.dangersense.DangerSense;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class DangerSenseConfig {
    public static final Detection detection;
    public static final EyeCategory eyeOfHostility;
    public static final Overlay overlay;
    private static final ForgeConfigSpec specification;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, specification);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        detection = new Detection(builder);
        eyeOfHostility = new EyeCategory(builder);
        overlay = new Overlay(builder);
        specification = builder.build();
    }

    public static class Overlay {
        public final ForgeConfigSpec.IntValue red;
        public final ForgeConfigSpec.IntValue green;
        public final ForgeConfigSpec.IntValue blue;

        Overlay(ForgeConfigSpec.Builder builder) {
            builder.push("overlay.colour");
            this.red = builder.comment("The red component of the overlay color").defineInRange("red", 255, 0, 255);
            this.green = builder.comment("The green component of the overlay color").defineInRange("green", 0, 0, 255);
            this.blue = builder.comment("The blue component of the overlay color").defineInRange("blue", 0, 0, 255);
            builder.pop(2);
        }
    }

    public static class EyeCategory {
        public final ForgeConfigSpec.IntValue degradationTicks;

        EyeCategory(ForgeConfigSpec.Builder builder) {
            builder.push("eye_of_hostility");
            this.degradationTicks = builder.comment("How many ticks the Eye of Hostility takes to degrade. The default is 4 Minecraft days, and the maximum is over 3 realtime years.").defineInRange("degradation.ticks", 96000, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Detection {
        public final ForgeConfigSpec.DoubleValue rangeXZ;
        public final ForgeConfigSpec.DoubleValue rangeY;
        public final ForgeConfigSpec.IntValue interval;
        private final ForgeConfigSpec.BooleanValue heuristics;
        static final Tags.IOptionalNamedTag<EntityType<?>> BLACKLIST = EntityTypeTags.createOptional((ResourceLocation)DangerSense.location("blacklist"));
        static final Tags.IOptionalNamedTag<EntityType<?>> WHITELIST = EntityTypeTags.createOptional((ResourceLocation)DangerSense.location("whitelist"));
        static final Tags.IOptionalNamedTag<EntityType<?>> HOSTILE = EntityTypeTags.createOptional((ResourceLocation)DangerSense.location("hostile"));

        Detection(ForgeConfigSpec.Builder builder) {
            builder.comment("Detection uses a cylinder centred on the player").push("detection");
            this.rangeXZ = builder.defineInRange("radius", 5.0, 3.0, 10.0);
            this.rangeY = builder.comment("Distance of the cylinder top and bottom from the player's feet").defineInRange("y", 2.0, 1.0, 3.0);
            this.interval = builder.comment("Ticks between detection scans. Shorter intervals may impact performance.").defineInRange("interval", 20, 10, 100);
            this.heuristics = builder.comment("Enables additional hostility detection mechanisms. Disable to use only the entity type tag " + HOSTILE.func_230234_a_()).define("heuristics", true);
            builder.pop();
        }

        public boolean isDetectable(Entity entity) {
            if (WHITELIST.isDefaulted()) {
                return !BLACKLIST.func_230235_a_((Object)entity.func_200600_R());
            }
            return WHITELIST.func_230235_a_((Object)entity.func_200600_R()) && !BLACKLIST.func_230235_a_((Object)entity.func_200600_R());
        }

        public boolean isHostile(Entity candidate) {
            if (candidate.func_200600_R().func_220341_a(HOSTILE)) {
                return true;
            }
            return (Boolean)this.heuristics.get() != false && candidate instanceof IMob;
        }
    }
}

