/*
 * Decompiled with CFR 0.152.
 */
package io.github.daomephsta.dangersense.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.daomephsta.dangersense.DangerSense;
import io.github.daomephsta.dangersense.DangerSenseConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dangersense", value={Dist.CLIENT})
public class DangerSenseOverlayRenderer
extends AbstractGui {
    private static final ResourceLocation VIGNETTE_TEXTURE = new ResourceLocation("textures/misc/vignette.png");
    private static final Minecraft client = Minecraft.func_71410_x();
    private static final Set<ItemStack> activeEyesBuffer = new HashSet<ItemStack>();

    public static boolean isEyeActive(ItemStack stack) {
        return activeEyesBuffer.contains(stack);
    }

    @SubscribeEvent
    public static void tickDetection(TickEvent.ClientTickEvent event) {
        if (DangerSenseOverlayRenderer.client.field_71441_e == null) {
            activeEyesBuffer.clear();
            return;
        }
        if (DangerSenseOverlayRenderer.client.field_71441_e.func_82737_E() % (long)((Integer)DangerSenseConfig.detection.interval.get()).intValue() != 0L) {
            return;
        }
        activeEyesBuffer.clear();
        double radius = (Double)DangerSenseConfig.detection.rangeXZ.get();
        AxisAlignedBB searchBox = DangerSenseOverlayRenderer.client.field_71439_g.func_174813_aQ().func_72314_b(radius, ((Double)DangerSenseConfig.detection.rangeY.get()).doubleValue(), radius);
        for (int slot = 0; slot < DangerSenseOverlayRenderer.client.field_71439_g.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = DangerSenseOverlayRenderer.client.field_71439_g.field_71071_by.func_70301_a(slot);
            if (stack.func_77973_b() != DangerSense.EYE_OF_HOSTILITY) continue;
            DangerSenseOverlayRenderer.searchForFocus(stack, searchBox, radius);
        }
    }

    private static void searchForFocus(ItemStack stack, AxisAlignedBB searchBox, double radius) {
        if (DangerSense.EYE_OF_HOSTILITY.hasFocus(stack)) {
            DangerSense.EYE_OF_HOSTILITY.getFocus(stack).ifPresent(focus -> {
                List found = DangerSenseOverlayRenderer.client.field_71441_e.func_217394_a(focus, searchBox, candidate -> DangerSenseOverlayRenderer.isDetectable((Entity)DangerSenseOverlayRenderer.client.field_71439_g, candidate, radius));
                if (!found.isEmpty()) {
                    activeEyesBuffer.add(stack);
                }
            });
        } else {
            List found = DangerSenseOverlayRenderer.client.field_71441_e.func_175674_a((Entity)DangerSenseOverlayRenderer.client.field_71439_g, searchBox, candidate -> DangerSenseOverlayRenderer.isDetectable((Entity)DangerSenseOverlayRenderer.client.field_71439_g, candidate, radius) && DangerSenseConfig.detection.isHostile((Entity)candidate));
            if (!found.isEmpty()) {
                activeEyesBuffer.add(stack);
            }
        }
    }

    private static boolean isDetectable(Entity owner, Entity entity, double radius) {
        return DangerSenseConfig.detection.isDetectable(entity) && entity.func_70068_e(owner) <= radius * radius;
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (activeEyesBuffer.isEmpty() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder vtxBuf = tesselator.func_178180_c();
        int screenHeight = client.func_228018_at_().func_198087_p();
        int screenWidth = client.func_228018_at_().func_198107_o();
        float red = (float)((Integer)DangerSenseConfig.overlay.red.get()).intValue() / 255.0f;
        float green = (float)((Integer)DangerSenseConfig.overlay.green.get()).intValue() / 255.0f;
        float blue = (float)((Integer)DangerSenseConfig.overlay.blue.get()).intValue() / 255.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)769, (int)1, (int)0);
        client.func_110434_K().func_110577_a(VIGNETTE_TEXTURE);
        vtxBuf.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        vtxBuf.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        vtxBuf.func_225582_a_(0.0, (double)screenHeight, 0.0).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        vtxBuf.func_225582_a_((double)screenWidth, (double)screenHeight, 0.0).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        vtxBuf.func_225582_a_((double)screenWidth, 0.0, 0.0).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tesselator.func_78381_a();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
    }
}

