/*
 * Decompiled with CFR 0.152.
 */
package io.github.daomephsta.dangersense.item;

import io.github.daomephsta.dangersense.DangerSense;
import io.github.daomephsta.dangersense.DangerSenseConfig;
import io.github.daomephsta.dangersense.util.Chat;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EyeOfHostilityItem
extends Item {
    private static final String TAG_FOCUS = "focus";
    private static final String TAG_DEGRADATION_TIMESTAMP = "degradation_timestamp";

    public EyeOfHostilityItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        Vector3d rayEnd;
        double distance = 8.0;
        Vector3d rayStart = entity.func_174824_e(1.0f);
        EntityRayTraceResult result = ProjectileHelper.func_221269_a((World)world, (Entity)entity, (Vector3d)rayStart, (Vector3d)(rayEnd = rayStart.func_178787_e(entity.func_70676_i(1.0f).func_186678_a(distance))), (AxisAlignedBB)entity.func_174813_aQ().func_216361_a(rayEnd).func_186662_g(distance), e -> true);
        if (result != null) {
            EntityType type = result.func_216348_a().func_200600_R();
            stack.func_196082_o().func_74778_a(TAG_FOCUS, type.getRegistryName().toString());
        } else {
            stack.func_196082_o().func_82580_o(TAG_FOCUS);
        }
        if (entity instanceof PlayerEntity) {
            Chat.pushToActionbar((PlayerEntity)entity, this.func_200295_i(stack));
        }
        return stack;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return this.getName(stack, super.func_200295_i(stack));
    }

    public ITextComponent getName(ItemStack stack, ITextComponent name) {
        if (this.hasFocus(stack)) {
            return (ITextComponent)this.getFocus(stack).map(type -> new TranslationTextComponent(this.func_77667_c(stack) + ".focus_specific", new Object[]{name, type.func_212546_e()})).orElseGet(() -> new TranslationTextComponent(this.func_77667_c(stack) + ".focus_null", new Object[]{name}));
        }
        return new TranslationTextComponent(this.func_77667_c(stack) + ".focus_hostiles", new Object[]{name});
    }

    public void func_77663_a(ItemStack stack, World world, Entity owner, int slot, boolean selected) {
        if (!stack.func_196082_o().func_74764_b(TAG_DEGRADATION_TIMESTAMP)) {
            stack.func_77978_p().func_74772_a(TAG_DEGRADATION_TIMESTAMP, world.func_82737_E() + (long)((Integer)DangerSenseConfig.eyeOfHostility.degradationTicks.get()).intValue());
        } else if (world.func_82737_E() >= stack.func_77978_p().func_74763_f(TAG_DEGRADATION_TIMESTAMP)) {
            ItemStack degraded = new ItemStack((IItemProvider)DangerSense.DEGRADED_EYE_OF_HOSTILITY);
            if (this.hasFocus(stack)) {
                degraded.func_77983_a(TAG_FOCUS, (INBT)StringNBT.func_229705_a_((String)stack.func_77978_p().func_74779_i(TAG_FOCUS)));
            }
            owner.func_174820_d(slot, degraded);
        }
    }

    public boolean hasFocus(ItemStack stack) {
        return stack.func_196082_o().func_74764_b(TAG_FOCUS);
    }

    public Optional<EntityType<?>> getFocus(ItemStack stack) {
        ResourceLocation id = new ResourceLocation(stack.func_77978_p().func_74779_i(TAG_FOCUS));
        return ForgeRegistries.ENTITIES.containsKey(id) ? Optional.of(ForgeRegistries.ENTITIES.getValue(id)) : Optional.empty();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }
}

