/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client.screen;

import com.google.common.collect.Lists;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.client.DietKeys;
import com.illusivesoulworks.diet.client.screen.DietTooltip;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.platform.Services;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class DietScreen
extends class_437 {
    private static final class_2960 BACKGROUND = new class_2960("minecraft", "textures/gui/demo_background.png");
    private static final class_2960 ICONS = new class_2960("diet", "textures/gui/icons.png");
    public static DietEffectsInfo tooltip = new DietEffectsInfo();
    private final Set<IDietGroup> groups = new HashSet<IDietGroup>();
    private final int xSize;
    private int ySize;
    private final boolean fromInventory;

    public DietScreen(boolean fromInventory) {
        super((class_2561)class_2561.method_43471((String)"gui.diet.title"));
        this.xSize = 248;
        this.fromInventory = fromInventory;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1687 != null) {
            this.groups.addAll(Services.CAPABILITY.get((class_1657)this.field_22787.field_1724).map(tracker -> DietSuites.getSuite((class_1937)this.field_22787.field_1687, tracker.getSuite()).map(IDietSuite::getGroups).orElse(Set.of())).orElse(Set.of()));
        }
        this.ySize = this.groups.size() * 20 + 60;
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 50, (this.field_22790 + this.ySize) / 2 - 30, 100, 20, (class_2561)class_2561.method_43471((String)"gui.diet.close"), p_213002_1_ -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                if (this.fromInventory) {
                    this.field_22787.method_1507((class_437)new class_490((class_1657)this.field_22787.field_1724));
                } else {
                    this.method_25419();
                }
            }
        }));
    }

    public void method_25394(@Nonnull class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.renderForeground(matrixStack, mouseX, mouseY);
        this.renderTitle(matrixStack, mouseX, mouseY);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderTitle(class_4587 matrixStack, int mouseX, int mouseY) {
        int titleWidth = this.field_22793.method_1727(this.field_22785.getString());
        this.field_22793.method_30883(matrixStack, this.field_22785, (float)this.field_22789 / 2.0f - (float)titleWidth / 2.0f, (float)this.field_22790 / 2.0f - (float)this.ySize / 2.0f + 10.0f, this.getTextColor());
        List<DietEffectsInfo.AttributeModifier> modifiers = tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = tooltip.getEffects();
        if (!(this.field_22787 == null || modifiers.isEmpty() && effects.isEmpty())) {
            RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
            int lowerX = this.field_22789 / 2 + titleWidth / 2 + 5;
            int lowerY = this.field_22790 / 2 - this.ySize / 2 + 7;
            int upperX = lowerX + 16;
            int upperY = lowerY + 16;
            class_332.method_25293((class_4587)matrixStack, (int)lowerX, (int)lowerY, (int)16, (int)16, (float)0.0f, (float)37.0f, (int)16, (int)16, (int)256, (int)256);
            if (mouseX >= lowerX && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                List<class_2561> tooltips = DietTooltip.getEffects();
                this.method_30901(matrixStack, tooltips, mouseX, mouseY);
            }
        }
    }

    private int getTextColor() {
        String config = (String)DietConfig.CLIENT.textColor.get();
        if (config.startsWith("#")) {
            return Integer.parseInt(config.substring(1), 16);
        }
        return Integer.parseInt(config);
    }

    public void renderForeground(class_4587 matrixStack, int mouseX, int mouseY) {
        class_746 player;
        if (this.field_22787 != null && this.field_22787.field_1687 != null && (player = this.field_22787.field_1724) != null) {
            Services.CAPABILITY.get((class_1657)player).ifPresent(diet -> DietSuites.getSuite((class_1937)this.field_22787.field_1687, diet.getSuite()).ifPresent(suite -> {
                int y = this.field_22790 / 2 - this.ySize / 2 + 25;
                int x = this.field_22789 / 2 - this.xSize / 2 + 10;
                class_5250 tooltip = null;
                for (IDietGroup group : suite.getGroups()) {
                    this.field_22788.method_4010(new class_1799((class_1935)group.getIcon()), x, y - 5);
                    class_5250 text = class_2561.method_43471((String)("groups.diet." + group.getName() + ".name"));
                    this.field_22793.method_30883(matrixStack, (class_2561)text, (float)(x + 20), (float)y, this.getTextColor());
                    RenderSystem.setShader(class_757::method_34541);
                    RenderSystem.setShaderTexture((int)0, (class_2960)ICONS);
                    DietColor color = diet.isActive() ? group.getColor() : DietColor.GRAY;
                    int red = color.red();
                    int green = color.green();
                    int blue = color.blue();
                    int percent = (int)Math.floor(diet.getValue(group.getName()) * 100.0f);
                    String percentText = percent + "%";
                    DietScreen.coloredBlit(matrixStack, x + 90, y + 2, 102, 5, 20.0f, 0.0f, 102, 5, 256, 256, red, green, blue, 255);
                    if (percent > 0) {
                        int texWidth = percent + 1;
                        DietScreen.coloredBlit(matrixStack, x + 90, y + 2, texWidth, 5, 20.0f, 5.0f, texWidth, 5, 256, 256, red, green, blue, 255);
                    }
                    int xPos = x + 200;
                    int yPos = y + 1;
                    this.field_22793.method_1729(matrixStack, percentText, (float)(xPos + 1), (float)yPos, 0);
                    this.field_22793.method_1729(matrixStack, percentText, (float)(xPos - 1), (float)yPos, 0);
                    this.field_22793.method_1729(matrixStack, percentText, (float)xPos, (float)(yPos + 1), 0);
                    this.field_22793.method_1729(matrixStack, percentText, (float)xPos, (float)(yPos - 1), 0);
                    this.field_22793.method_1729(matrixStack, percentText, (float)xPos, (float)yPos, color.getRGB());
                    int lowerY = y - 5;
                    int upperX = x + 16;
                    int upperY = lowerY + 16;
                    if (mouseX >= x && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                        String key = "groups.diet." + group.getName() + ".tooltip";
                        if (class_2477.method_10517().method_4678(key)) {
                            tooltip = class_2561.method_43471((String)key);
                        }
                    }
                    y += 20;
                }
                if (tooltip != null) {
                    ArrayList tooltips = Lists.newArrayList((Object[])new class_2561[]{tooltip});
                    this.method_30901(matrixStack, tooltips, mouseX, mouseY);
                }
            }));
        }
    }

    public void method_25420(@Nonnull class_4587 matrixStack) {
        super.method_25420(matrixStack);
        if (this.field_22787 != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND);
            int i = (this.field_22789 - this.xSize) / 2;
            int j = (this.field_22790 - this.ySize) / 2;
            class_332.method_25293((class_4587)matrixStack, (int)i, (int)j, (int)this.xSize, (int)4, (float)0.0f, (float)0.0f, (int)248, (int)4, (int)256, (int)256);
            class_332.method_25293((class_4587)matrixStack, (int)i, (int)(j + 4), (int)this.xSize, (int)(this.ySize - 8), (float)0.0f, (float)4.0f, (int)248, (int)24, (int)256, (int)256);
            class_332.method_25293((class_4587)matrixStack, (int)i, (int)(j + this.ySize - 4), (int)this.xSize, (int)4, (float)0.0f, (float)162.0f, (int)248, (int)4, (int)256, (int)256);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.field_22787.method_1507((class_437)new class_490((class_1657)this.field_22787.field_1724));
                return true;
            }
            if (DietKeys.OPEN_GUI.method_1417(keyCode, scanCode)) {
                if (this.fromInventory) {
                    this.field_22787.method_1507((class_437)new class_490((class_1657)this.field_22787.field_1724));
                } else {
                    this.method_25419();
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    private static void coloredBlit(class_4587 matrixStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        int x2 = x + width;
        int y2 = y + height;
        float minU = (uOffset + 0.0f) / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = (vOffset + 0.0f) / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        class_1159 matrix = matrixStack.method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        bufferbuilder.method_22918(matrix, (float)x, (float)y2, 0.0f).method_1336(red, green, blue, alpha).method_22913(minU, maxV).method_1344();
        bufferbuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_1336(red, green, blue, alpha).method_22913(maxU, maxV).method_1344();
        bufferbuilder.method_22918(matrix, (float)x2, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_22913(maxU, minV).method_1344();
        bufferbuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_1336(red, green, blue, alpha).method_22913(minU, minV).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }
}

