/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.suite;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietAttribute;
import com.illusivesoulworks.diet.api.type.IDietCondition;
import com.illusivesoulworks.diet.api.type.IDietStatusEffect;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.common.data.effect.DietEffect;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.common.data.suite.DietSuite;
import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_1291;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class DietSuites
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String UUID_PREFIX = "ea4130c8-9065-48a6-9207-ddc020fb9fc8";
    public static final DietSuites SERVER = Services.CAPABILITY.getSuitesListener();
    public static final DietSuites CLIENT = Services.CAPABILITY.getSuitesListener();
    private Map<String, IDietSuite> suites = new HashMap<String, IDietSuite>();
    private int uuidSuffix = 0;

    public DietSuites() {
        super(GSON, "diet/suites");
    }

    public static Optional<IDietSuite> getSuite(class_1937 level, String name) {
        DietSuites instance = level.method_8608() ? CLIENT : SERVER;
        return Optional.ofNullable(instance.suites.get(name));
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, IDietSuite> entry : this.suites.entrySet()) {
            tag.method_10566(entry.getKey(), (class_2520)entry.getValue().save());
        }
        return tag;
    }

    public void load(class_2487 tag) {
        HashMap<String, IDietSuite> loaded = new HashMap<String, IDietSuite>();
        for (String key : tag.method_10541()) {
            loaded.put(key, DietSuite.load((class_2487)Objects.requireNonNull(tag.method_10580(key))));
        }
        this.suites = loaded;
    }

    public void sync(class_3222 player) {
        Services.NETWORK.sendDietSuitesS2C(player, this.save());
    }

    protected void apply(@Nonnull Map<class_2960, JsonElement> object, @Nonnull class_3300 resourceManager, @Nonnull class_3695 profilerFiller) {
        class_2960 resourcelocation;
        HashMap<String, DietSuite.Builder> map = new HashMap<String, DietSuite.Builder>();
        this.uuidSuffix = 0;
        for (Map.Entry<class_2960, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (!resourcelocation.method_12836().equals("diet")) continue;
            try {
                this.buildSuite(map.computeIfAbsent(resourcelocation.method_12832(), DietSuite.Builder::new), class_3518.method_15295((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet suite {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<class_2960, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (resourcelocation.method_12832().startsWith("_") || resourcelocation.method_12836().equals("diet")) continue;
            try {
                this.buildSuite(map.computeIfAbsent(resourcelocation.method_12832(), DietSuite.Builder::new), class_3518.method_15295((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet suite {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.suites = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DietSuite.Builder)entry.getValue()).build()));
        DietConstants.LOG.info("Loaded {} diet suites", (Object)map.size());
    }

    private void buildSuite(DietSuite.Builder builder, JsonObject topElement) {
        boolean replace = class_3518.method_15258((JsonObject)topElement, (String)"replace", (boolean)false);
        JsonArray empty = new JsonArray();
        JsonArray groups = class_3518.method_15292((JsonObject)topElement, (String)"groups", (JsonArray)empty);
        if (replace) {
            builder.clear();
        }
        for (JsonElement group : groups) {
            DietGroups.SERVER.getGroup(group.getAsString()).ifPresent(builder::group);
        }
        JsonArray effects = class_3518.method_15292((JsonObject)topElement, (String)"effects", (JsonArray)empty);
        for (JsonElement effect : effects) {
            Object condition2;
            JsonObject effectObject = effect.getAsJsonObject();
            JsonArray conditions = class_3518.method_15292((JsonObject)effectObject, (String)"conditions", (JsonArray)empty);
            JsonArray attributes = class_3518.method_15292((JsonObject)effectObject, (String)"attributes", (JsonArray)empty);
            JsonArray statusEffects = class_3518.method_15292((JsonObject)effectObject, (String)"status_effects", (JsonArray)empty);
            if (conditions.size() == 0) {
                throw new IllegalArgumentException("Conditions cannot be empty!");
            }
            if (attributes.size() == 0 && statusEffects.size() == 0) {
                throw new IllegalArgumentException("Both attributes and status_effects cannot be empty!");
            }
            ArrayList<IDietCondition> finalConditions = new ArrayList<IDietCondition>();
            for (Object condition2 : conditions) {
                JsonObject conditionObject = condition2.getAsJsonObject();
                JsonArray conditionGroups = class_3518.method_15292((JsonObject)conditionObject, (String)"groups", (JsonArray)empty);
                HashSet<String> set = new HashSet<String>();
                for (JsonElement conditionGroup : conditionGroups) {
                    set.add(conditionGroup.getAsString());
                }
                String match = class_3518.method_15253((JsonObject)conditionObject, (String)"match", (String)"any");
                float above = class_3518.method_15277((JsonObject)conditionObject, (String)"above", (float)0.0f);
                float below = class_3518.method_15277((JsonObject)conditionObject, (String)"below", (float)1.0f);
                finalConditions.add(new DietEffect.DietCondition(set, DietEffect.MatchMethod.findOrDefault(match, DietEffect.MatchMethod.ANY), above, below));
            }
            ArrayList<IDietAttribute> finalAttributes = new ArrayList<IDietAttribute>();
            condition2 = attributes.iterator();
            while (condition2.hasNext()) {
                JsonElement attribute = (JsonElement)condition2.next();
                JsonObject attributeObject = attribute.getAsJsonObject();
                if (!attributeObject.has("name")) {
                    throw new IllegalArgumentException("Attribute requires a name!");
                }
                String name = class_3518.method_15265((JsonObject)attributeObject, (String)"name");
                Services.REGISTRY.getAttribute(new class_2960(name)).ifPresentOrElse(att -> {
                    float amount = class_3518.method_15277((JsonObject)attributeObject, (String)"amount", (float)1.0f);
                    class_1322.class_1323 op = DietSuites.getOperation(class_3518.method_15253((JsonObject)attributeObject, (String)"operation", (String)""));
                    float increment = class_3518.method_15277((JsonObject)attributeObject, (String)"increment", (float)amount);
                    finalAttributes.add(new DietEffect.DietAttribute((class_1320)att, op, amount, increment));
                }, () -> {
                    throw new IllegalArgumentException("Attribute " + name + " does not exist!");
                });
            }
            ArrayList<IDietStatusEffect> finalStatusEffects = new ArrayList<IDietStatusEffect>();
            for (JsonElement statusEffect : statusEffects) {
                JsonObject statusEffectObject = statusEffect.getAsJsonObject();
                if (!statusEffectObject.has("name")) {
                    throw new IllegalArgumentException("Status effect requires a name!");
                }
                String name = class_3518.method_15265((JsonObject)statusEffectObject, (String)"name");
                Services.REGISTRY.getStatusEffect(new class_2960(name)).ifPresentOrElse(eff -> {
                    int power = class_3518.method_15282((JsonObject)statusEffectObject, (String)"power", (int)0);
                    int increment = class_3518.method_15282((JsonObject)statusEffectObject, (String)"increment", (int)1);
                    finalStatusEffects.add(new DietEffect.DietStatusEffect((class_1291)eff, power, increment));
                }, () -> {
                    throw new IllegalArgumentException("Attribute " + name + " does not exist!");
                });
            }
            UUID uuid = UUID.nameUUIDFromBytes((UUID_PREFIX + this.uuidSuffix).getBytes());
            ++this.uuidSuffix;
            builder.effect(new DietEffect(uuid, finalAttributes, finalStatusEffects, finalConditions));
        }
    }

    private static class_1322.class_1323 getOperation(String name) {
        if (name.equals("multiply_total")) {
            return class_1322.class_1323.field_6331;
        }
        if (name.equals("multiply_base")) {
            return class_1322.class_1323.field_6330;
        }
        return class_1322.class_1323.field_6328;
    }
}

