/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client;

import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietResult;
import com.illusivesoulworks.diet.client.DietKeys;
import com.illusivesoulworks.diet.client.screen.DietScreen;
import com.illusivesoulworks.diet.client.screen.DynamicButton;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.util.DietResult;
import com.illusivesoulworks.diet.platform.ClientServices;
import com.illusivesoulworks.diet.platform.Services;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class DietClientEvents {
    private static final class_6862<class_1792> SPECIAL_FOOD = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("diet", "special_food"));
    private static final DecimalFormat DECIMALFORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("#.#"), num -> num.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final class_2960 ICONS = new class_2960("diet", "textures/gui/icons.png");
    public static List<class_2561> tooltip = null;
    public static int tooltipX = 0;
    public static int tooltipY = 0;

    public static void tick(class_310 mc) {
        class_746 player = mc.field_1724;
        if (player != null && mc.method_1569() && !(mc.field_1755 instanceof DietScreen) && DietKeys.OPEN_GUI.method_1436()) {
            mc.method_1507((class_437)new DietScreen(mc.field_1755 instanceof class_490));
        }
    }

    public static DynamicButton getButton(class_437 screen) {
        if (((Boolean)DietConfig.CLIENT.addButton.get()).booleanValue()) {
            class_465 containerScreen = (class_465)screen;
            return new DynamicButton(containerScreen, ClientServices.INSTANCE.getGuiLeft(containerScreen) + (Integer)DietConfig.CLIENT.buttonX.get(), containerScreen.field_22790 / 2 + (Integer)DietConfig.CLIENT.buttonY.get(), 20, 18, 0, 0, 19, ICONS, button -> class_310.method_1551().method_1507((class_437)new DietScreen(true)));
        }
        return null;
    }

    public static void renderEffectsTooltip(class_437 screen, class_332 guiGraphics) {
        if (tooltip != null && screen != null) {
            guiGraphics.method_51437(class_310.method_1551().field_1772, tooltip, Optional.empty(), tooltipX, tooltipY);
            tooltip = null;
        }
    }

    public static void renderItemTooltip(class_1657 player, class_1799 stack, List<class_2561> tooltips) {
        if (player != null) {
            if (((Boolean)DietConfig.SERVER.hideTooltipsUntilEaten.get()).booleanValue() && Services.CAPABILITY.get(player).map(tracker -> !tracker.getEaten().contains(stack.method_7909())).orElse(false).booleanValue()) {
                return;
            }
            IDietResult result = DietApi.getInstance().get(player, stack);
            if (result != DietResult.EMPTY) {
                Map<IDietGroup, Float> groups = result.get();
                boolean specialFood = stack.method_31573(SPECIAL_FOOD);
                if (!groups.isEmpty()) {
                    ArrayList groupsTooltips = new ArrayList();
                    ArrayList<class_5250> beneficial = new ArrayList<class_5250>();
                    ArrayList<class_5250> harmful = new ArrayList<class_5250>();
                    for (Map.Entry<IDietGroup, Float> entry : groups.entrySet()) {
                        float value = entry.getValue().floatValue();
                        class_5250 groupName = class_2561.method_43471((String)("groups.diet." + entry.getKey().getName() + ".name"));
                        class_5250 tooltip = null;
                        if (specialFood) {
                            tooltip = class_2561.method_43469((String)"tooltip.diet.group_", (Object[])new Object[]{groupName});
                        } else if (value > 0.0f) {
                            tooltip = class_2561.method_43469((String)"tooltip.diet.group", (Object[])new Object[]{DECIMALFORMAT.format(entry.getValue().floatValue() * 100.0f), groupName});
                        }
                        if (tooltip == null) continue;
                        if (entry.getKey().isBeneficial()) {
                            tooltip.method_27692(class_124.field_1060);
                            beneficial.add(tooltip);
                            continue;
                        }
                        tooltip.method_27692(class_124.field_1061);
                        harmful.add(tooltip);
                    }
                    groupsTooltips.addAll(beneficial);
                    groupsTooltips.addAll(harmful);
                    if (!groupsTooltips.isEmpty()) {
                        tooltips.add((class_2561)class_2561.method_43473());
                        tooltips.add((class_2561)class_2561.method_43471((String)"tooltip.diet.eaten").method_27692(class_124.field_1080));
                        tooltips.addAll(groupsTooltips);
                    }
                }
            }
        }
    }
}

