/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common;

import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietResult;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.common.util.DietResult;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1320;
import net.minecraft.class_1329;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4174;
import org.apache.commons.lang3.tuple.Triple;

public class DietApiImpl
extends DietApi {
    private static final class_1320 NATURAL_REGEN = new class_1329("diet.naturalRegeneration", 1.0, 0.0, 2.0).method_26829(true);

    @Override
    public Set<IDietGroup> getGroups(class_1657 player, class_1799 input) {
        HashSet<IDietGroup> groups = new HashSet<IDietGroup>();
        HashSet<class_1799> processed = new HashSet<class_1799>();
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        ArrayDeque<class_1799> queue = new ArrayDeque<class_1799>();
        queue.add(input);
        while (!queue.isEmpty()) {
            class_1799 next = (class_1799)queue.poll();
            BiFunction<class_1657, class_1799, Triple<List<class_1799>, Integer, Float>> func = Services.REGISTRY.getOverride(next.method_7909());
            if (func != null) {
                List candidates = (List)func.apply(player, next).getLeft();
                if (candidates.isEmpty()) {
                    stacks.add(next);
                    continue;
                }
                for (class_1799 candidate : candidates) {
                    if (processed.add(candidate)) {
                        queue.add(candidate);
                        continue;
                    }
                    stacks.add(candidate);
                }
                continue;
            }
            stacks.add(next);
        }
        for (class_1799 stack : stacks) {
            HashSet<IDietGroup> found = new HashSet<IDietGroup>();
            for (IDietGroup group : DietGroups.getGroups(player.method_37908())) {
                if (!group.contains(stack)) continue;
                found.add(group);
            }
            if (found.isEmpty()) {
                groups.addAll(DietValueGenerator.get(stack.method_7909()).orElse(new HashSet()));
                continue;
            }
            groups.addAll(found);
        }
        return groups.isEmpty() ? (Set)DietValueGenerator.get(input.method_7909()).orElse(new HashSet()) : groups;
    }

    @Override
    public IDietResult get(class_1657 player, class_1799 input) {
        float saturation;
        float healing;
        Set<IDietGroup> groups = this.getGroups(player, input);
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        class_1792 item = input.method_7909();
        class_4174 food = Services.REGISTRY.getFoodProperties(input, player);
        BiFunction<class_1657, class_1799, Triple<List<class_1799>, Integer, Float>> func = Services.REGISTRY.getOverride(item);
        Float override = DietConfig.SERVER.getFoodOverride(item);
        if (override != null) {
            healing = override.floatValue();
            saturation = 0.0f;
        } else if (func != null) {
            Triple<List<class_1799>, Integer, Float> apply = func.apply(player, input);
            healing = ((Integer)apply.getMiddle()).intValue();
            saturation = ((Float)apply.getRight()).floatValue();
        } else if (food != null) {
            healing = food.method_19230();
            saturation = food.method_19231();
            if (healing == 0.0f) {
                return DietResult.EMPTY;
            }
        } else {
            HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
            for (IDietGroup group : groups) {
                result.put(group, Float.valueOf(0.0f));
            }
            return new DietResult(result);
        }
        return new DietResult(DietApiImpl.calculate(healing, saturation, groups));
    }

    @Override
    public IDietResult get(class_1657 player, class_1799 input, int healing, float saturation) {
        return this.get(player, Collections.singletonList(input), healing, saturation);
    }

    @Override
    public IDietResult get(class_1657 player, List<class_1799> stacks, int food, float saturation) {
        HashSet<IDietGroup> groups = new HashSet<IDietGroup>();
        for (class_1799 stack : stacks) {
            groups.addAll(this.getGroups(player, stack));
        }
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        return new DietResult(DietApiImpl.calculate(food, saturation, groups));
    }

    private static Map<IDietGroup, Float> calculate(float healing, float saturation, Set<IDietGroup> groups) {
        float quality = (healing + healing * saturation) / (float)groups.size();
        float gain = quality * 0.25f / (quality + 15.0f);
        gain = (float)((double)gain * Math.pow(1.0f - (float)((Integer)DietConfig.SERVER.gainPenaltyPerGroup.get()).intValue() / 100.0f, groups.size() - 1));
        HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
        for (IDietGroup group : groups) {
            float value = (float)((double)gain * group.getGainMultiplier());
            value = Math.max(0.005f, (float)Math.round(value * 200.0f) / 200.0f);
            result.put(group, Float.valueOf(value));
        }
        return result;
    }

    @Override
    public class_1320 getNaturalRegeneration() {
        return NATURAL_REGEN;
    }
}

