/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.suite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.illusivesoulworks.diet.api.type.IDietEffect;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.common.data.group.DietGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class DietSuite
implements IDietSuite {
    private final String name;
    private final Set<IDietGroup> groups;
    private final List<IDietEffect> effects;

    private DietSuite(String name, Set<IDietGroup> groups, List<IDietEffect> effects) {
        this.name = name;
        TreeSet<IDietGroup> sorted = new TreeSet<IDietGroup>(Comparator.comparing(IDietGroup::getOrder).thenComparing(IDietGroup::getName));
        sorted.addAll(groups);
        this.groups = ImmutableSet.copyOf(sorted);
        this.effects = ImmutableList.copyOf(effects);
    }

    public static IDietSuite load(class_2487 tag) {
        HashSet<IDietGroup> set = new HashSet<IDietGroup>();
        class_2487 groups = (class_2487)tag.method_10580("Groups");
        if (groups != null) {
            for (String key : groups.method_10541()) {
                set.add(DietGroup.load((class_2487)Objects.requireNonNull(groups.method_10580(key))));
            }
        }
        return new DietSuite(tag.method_10558("Name"), set, new ArrayList<IDietEffect>());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<IDietGroup> getGroups() {
        return this.groups;
    }

    @Override
    public List<IDietEffect> getEffects() {
        return this.effects;
    }

    @Override
    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10582("Name", this.name);
        class_2487 groups = new class_2487();
        for (IDietGroup group : this.groups) {
            groups.method_10566(group.getName(), (class_2520)group.save());
        }
        tag.method_10566("Groups", (class_2520)groups);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DietSuite dietSuite = (DietSuite)o;
        return Objects.equals(this.name, dietSuite.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final String name;
        private final Set<IDietGroup> groups;
        private final List<IDietEffect> effects;

        public Builder(String name) {
            this.name = name;
            this.groups = new TreeSet<IDietGroup>(Comparator.comparingInt(IDietGroup::getOrder).thenComparing(IDietGroup::getName));
            this.effects = new ArrayList<IDietEffect>();
        }

        public Builder group(IDietGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder groups(Set<IDietGroup> groups) {
            this.groups.addAll(groups);
            return this;
        }

        public Builder effect(IDietEffect effect) {
            this.effects.add(effect);
            return this;
        }

        public Builder effects(List<IDietEffect> effects) {
            this.effects.addAll(effects);
            return this;
        }

        public Builder clear() {
            this.groups.clear();
            this.effects.clear();
            return this;
        }

        public IDietSuite build() {
            return new DietSuite(this.name, this.groups, this.effects);
        }
    }
}

