/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.util;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;

public class DietValueGenerator {
    private static final Map<class_1792, Set<IDietGroup>> GENERATED = new HashMap<class_1792, Set<IDietGroup>>();
    private static final Map<class_1792, List<class_1792>> TRAILS = new HashMap<class_1792, List<class_1792>>();
    private static final Comparator<class_1799> COMPARATOR = new IngredientComparator();
    private static final Set<class_1792> UNGROUPED = new HashSet<class_1792>();
    private static final Map<class_1792, List<class_1860<?>>> RECIPES = new HashMap();
    private static final Set<class_1792> PROCESSED = new HashSet<class_1792>();

    public static void reload(MinecraftServer server) {
        GENERATED.clear();
        TRAILS.clear();
        if (((Boolean)DietConfig.SERVER.generateGroupsForEmptyItems.get()).booleanValue()) {
            DietConstants.LOG.info("Generating diet values...");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            stopwatch.reset();
            stopwatch.start();
            Set<IDietGroup> groups = DietGroups.getGroups((class_1937)server.method_30002());
            DietValueGenerator.findUngroupedFoods(groups);
            class_1863 recipeManager = server.method_3772();
            DietValueGenerator.findAllRecipesForItems(recipeManager, server.method_30002().method_30349());
            DietValueGenerator.processItems(groups);
            stopwatch.stop();
            DietConstants.LOG.info("Generating diet values took {}", (Object)stopwatch);
        }
    }

    private static void processItems(Set<IDietGroup> groups) {
        DietConstants.LOG.info("Processing items...");
        PROCESSED.clear();
        for (class_1792 item : UNGROUPED) {
            if (PROCESSED.contains(item)) continue;
            ArrayList<class_1792> trail = new ArrayList<class_1792>();
            DietValueGenerator.findGroups(groups, item, trail);
        }
        DietConstants.LOG.info("Processed {} items", (Object)PROCESSED.size());
    }

    private static Set<IDietGroup> findGroups(Set<IDietGroup> groups, class_1792 targetItem, List<class_1792> trail) {
        List<class_1860<?>> list;
        PROCESSED.add(targetItem);
        HashSet<IDietGroup> result = new HashSet<IDietGroup>();
        class_1799 proxy = new class_1799((class_1935)targetItem);
        for (IDietGroup group : groups) {
            if (!group.contains(proxy)) continue;
            result.add(group);
        }
        if (result.isEmpty() && (list = RECIPES.get(targetItem)) != null) {
            HashSet<IDietGroup> found = new HashSet<IDietGroup>();
            for (class_1860<?> recipe : list) {
                HashSet<class_1792> keys = new HashSet<class_1792>();
                block2: for (class_1856 ingredient : recipe.method_8117()) {
                    class_1799[] itemStacks = (class_1799[])ingredient.method_8105().clone();
                    if (itemStacks.length == 0) continue;
                    Arrays.sort(itemStacks, COMPARATOR);
                    for (int i = 0; i < itemStacks.length; ++i) {
                        ArrayList<class_1792> subTrail;
                        class_1799 stack = itemStacks[i];
                        class_1792 item = stack.method_7909();
                        if (i == 0) {
                            if (keys.contains(item)) continue block2;
                            keys.add(item);
                        }
                        if (Services.REGISTRY.isIngredient(stack)) continue;
                        Set<IDietGroup> fallback = GENERATED.get(item);
                        boolean addTrail = false;
                        if (fallback != null) {
                            found.addAll(fallback);
                            addTrail = !fallback.isEmpty();
                        } else if (!PROCESSED.contains(item)) {
                            subTrail = new ArrayList();
                            HashSet<IDietGroup> pending = new HashSet<IDietGroup>(DietValueGenerator.findGroups(groups, item, subTrail));
                            found.addAll(pending);
                            GENERATED.putIfAbsent(item, pending);
                            TRAILS.putIfAbsent(item, subTrail);
                            boolean bl = addTrail = !pending.isEmpty();
                        }
                        if (addTrail && (subTrail = TRAILS.get(item)) != null) {
                            trail.add(item);
                            trail.addAll(subTrail);
                        }
                        if (!found.isEmpty()) continue block2;
                    }
                }
                if (found.isEmpty()) continue;
                break;
            }
            result.addAll(found);
        }
        GENERATED.putIfAbsent(targetItem, result);
        TRAILS.putIfAbsent(targetItem, trail);
        return result;
    }

    private static void findAllRecipesForItems(class_1863 recipeManager, class_5455 registryAccess) {
        DietConstants.LOG.info("Building item-to-recipes map...");
        RECIPES.clear();
        HashMap<class_1792, List> result = new HashMap<class_1792, List>();
        for (class_1860 recipe : recipeManager.method_8126()) {
            class_1799 output = class_1799.field_8037;
            try {
                output = recipe.method_8110(registryAccess);
            }
            catch (Exception e) {
                DietConstants.LOG.error("Diet was unable to process recipe: {}", (Object)recipe.method_8114());
            }
            if (output == null) {
                DietConstants.LOG.debug("Diet was unable to process recipe due to null output: {}", (Object)recipe.method_8114());
                continue;
            }
            class_1792 item = output.method_7909();
            List current = result.computeIfAbsent(item, k -> new ArrayList());
            current.add(recipe);
        }
        for (List list : result.values()) {
            if (list.size() <= 1) continue;
            list.sort(Comparator.comparing(class_1860::method_8114));
        }
        RECIPES.putAll(result);
        DietConstants.LOG.info("Found {} valid items with recipes", (Object)RECIPES.size());
    }

    private static void findUngroupedFoods(Set<IDietGroup> groups) {
        DietConstants.LOG.info("Finding ungrouped food items...");
        UNGROUPED.clear();
        HashSet<class_1792> result = new HashSet<class_1792>();
        block0: for (class_1792 item : Services.REGISTRY.getItems()) {
            class_1799 stack = item.method_7854();
            class_4174 food = Services.REGISTRY.getFoodProperties(stack, null);
            if ((food == null || food.method_19230() <= 0) && !Services.REGISTRY.isSpecialFood(stack)) continue;
            for (IDietGroup group : groups) {
                if (!group.contains(new class_1799((class_1935)item))) continue;
                continue block0;
            }
            result.add(item);
        }
        UNGROUPED.addAll(result);
        DietConstants.LOG.info("Found {} ungrouped food items", (Object)UNGROUPED.size());
    }

    public static Map<class_1792, Set<IDietGroup>> getAll() {
        return ImmutableMap.copyOf(GENERATED);
    }

    public static void load(Map<class_1792, Set<String>> generated) {
        GENERATED.clear();
        for (Map.Entry<class_1792, Set<String>> entry : generated.entrySet()) {
            class_1792 item = entry.getKey();
            HashSet groups = new HashSet();
            for (String s : entry.getValue()) {
                DietGroups.CLIENT.getGroup(s).ifPresent(groups::add);
            }
            GENERATED.put(item, groups);
        }
    }

    public static Optional<Set<IDietGroup>> get(class_1792 item) {
        return Optional.ofNullable(GENERATED.get(item));
    }

    public static List<class_1792> getTrail(class_1792 item) {
        return TRAILS.getOrDefault(item, Collections.emptyList());
    }

    private static class IngredientComparator
    implements Comparator<class_1799> {
        private IngredientComparator() {
        }

        @Override
        public int compare(class_1799 o1, class_1799 o2) {
            class_2960 rl1 = Services.REGISTRY.getItemKey(o1.method_7909());
            class_2960 rl2 = Services.REGISTRY.getItemKey(o2.method_7909());
            if (rl1 == null) {
                return 1;
            }
            if (rl2 == null) {
                return -1;
            }
            String namespace1 = rl1.method_12836();
            String namespace2 = rl2.method_12836();
            if (namespace1.equals("minecraft") && !namespace2.equals("minecraft")) {
                return -1;
            }
            if (namespace2.equals("minecraft") && !namespace1.equals("minecraft")) {
                return 1;
            }
            return rl1.method_12833(rl2);
        }
    }
}

