/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.common.capability.DietTrackerCapability;
import top.theillusivec4.diet.common.command.DietCommand;
import top.theillusivec4.diet.common.command.DietGroupArgument;
import top.theillusivec4.diet.common.config.data.DietConfigReader;
import top.theillusivec4.diet.common.integration.IntegrationManager;
import top.theillusivec4.diet.common.network.DietNetwork;
import top.theillusivec4.diet.common.util.DietOverride;

@Mod(value="diet")
public class DietMod {
    public static final String MOD_ID = "diet";
    public static final Logger LOGGER = LogManager.getLogger();

    public static String id(String name) {
        return "diet:" + name;
    }

    public DietMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::parallelDispatch);
        eventBus.addListener(this::process);
        MinecraftForge.EVENT_BUS.addListener(this::setupCommands);
        DietConfigReader.setup();
    }

    private void setup(FMLCommonSetupEvent evt) {
        DietTrackerCapability.setup();
        DietNetwork.setup();
        IntegrationManager.setup();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        DietKeys.setup();
    }

    private void parallelDispatch(ParallelDispatchEvent evt) {
        evt.enqueueWork(() -> ArgumentTypes.func_218136_a((String)DietMod.id("group"), DietGroupArgument.class, (IArgumentSerializer)new ArgumentSerializer(DietGroupArgument::group)));
    }

    private void process(InterModProcessEvent evt) {
        DietOverride.process(evt.getIMCStream());
    }

    private void setupCommands(RegisterCommandsEvent evt) {
        DietCommand.register((CommandDispatcher<CommandSource>)evt.getDispatcher());
    }
}

