/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.client.DietScreen;
import top.theillusivec4.diet.client.DietTooltip;
import top.theillusivec4.diet.common.config.DietClientConfig;
import top.theillusivec4.diet.common.integration.CuriosIntegration;
import top.theillusivec4.diet.common.integration.IntegrationManager;
import top.theillusivec4.diet.common.util.DietResult;

@Mod.EventBusSubscriber(modid="diet", value={Dist.CLIENT})
public class DietClientEventsListener {
    private static final DecimalFormat DECIMALFORMAT = (DecimalFormat)Util.func_200696_a((Object)new DecimalFormat("#.#"), num -> num.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");

    @SubscribeEvent
    public static void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        Screen screen = evt.getGui();
        if (screen instanceof InventoryScreen || IntegrationManager.isCuriosLoaded() && CuriosIntegration.isCuriosScreen(screen)) {
            ContainerScreen containerScreen = (ContainerScreen)screen;
            evt.addWidget((Widget)new DynamicButton(containerScreen, containerScreen.getGuiLeft() + DietClientConfig.buttonX, containerScreen.field_230709_l_ / 2 + DietClientConfig.buttonY, 20, 18, 0, 0, 19, ICONS, button -> Minecraft.func_71410_x().func_147108_a((Screen)new DietScreen(true))));
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && evt.phase == TickEvent.Phase.END && mc.func_195544_aj() && !(mc.field_71462_r instanceof DietScreen) && DietKeys.OPEN_GUI.func_151468_f()) {
            mc.func_147108_a((Screen)new DietScreen(mc.field_71462_r instanceof InventoryScreen));
        }
    }

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent evt) {
        Map<IDietGroup, Float> groups;
        IDietResult result;
        PlayerEntity player = evt.getPlayer();
        List tooltips = evt.getToolTip();
        ItemStack stack = evt.getItemStack();
        if (player != null && (result = DietApi.getInstance().get(player, stack)) != DietResult.EMPTY && !(groups = result.get()).isEmpty()) {
            tooltips.add(StringTextComponent.field_240750_d_);
            tooltips.add(new TranslationTextComponent("tooltip.diet.eaten").func_240699_a_(TextFormatting.GRAY));
            for (Map.Entry<IDietGroup, Float> entry : groups.entrySet()) {
                float value = entry.getValue().floatValue();
                TranslationTextComponent groupName = new TranslationTextComponent("groups.diet." + entry.getKey().getName() + ".name");
                if (value > 0.0f) {
                    tooltips.add(new TranslationTextComponent("tooltip.diet.group", new Object[]{DECIMALFORMAT.format(entry.getValue().floatValue() * 100.0f), groupName}).func_240699_a_(TextFormatting.GREEN));
                    continue;
                }
                tooltips.add(new TranslationTextComponent("tooltip.diet.group_", new Object[]{groupName}).func_240699_a_(TextFormatting.GREEN));
            }
        }
    }

    public static class DynamicButton
    extends ImageButton {
        private final ContainerScreen<?> containerScreen;

        public DynamicButton(ContainerScreen<?> screenIn, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.containerScreen = screenIn;
        }

        public void func_230431_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.field_230690_l_ = this.containerScreen.getGuiLeft() + DietClientConfig.buttonX;
            this.field_230691_m_ = this.containerScreen.getGuiTop() + DietClientConfig.buttonY + 83;
            super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void func_230443_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            List<ITextComponent> tooltips = DietTooltip.getEffects();
            if (!tooltips.isEmpty()) {
                this.containerScreen.renderWrappedToolTip(matrixStack, tooltips, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
            }
        }
    }
}

