/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.client.DietKeys;
import top.theillusivec4.diet.client.DietTooltip;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.group.DietGroups;

public class DietScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/demo_background.png");
    private static final ResourceLocation ICONS = new ResourceLocation("diet", "textures/gui/icons.png");
    public static DietEffectsInfo tooltip = new DietEffectsInfo();
    private final int xSize;
    private final int ySize;
    private final boolean fromInventory;

    public DietScreen(boolean fromInventory) {
        super((ITextComponent)new TranslationTextComponent("gui.diet.title"));
        this.xSize = 248;
        this.ySize = 166;
        this.fromInventory = fromInventory;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int numGroups = DietGroups.get().size();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, (this.field_230709_l_ - this.ySize) / 2 + (1 + numGroups) * 18 + 14, 100, 20, (ITextComponent)new TranslationTextComponent("gui.diet.close"), p_213002_1_ -> {
            if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
                if (this.fromInventory) {
                    this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_230706_i_.field_71439_g));
                } else {
                    this.func_231175_as__();
                }
            }
        }));
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.renderForeground(matrixStack);
        this.renderTitle(matrixStack, mouseX, mouseY);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderTitle(MatrixStack matrixStack, int mouseX, int mouseY) {
        int titleWidth = this.field_230712_o_.func_78256_a(this.field_230704_d_.getString());
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_230708_k_ / 2.0f - (float)titleWidth / 2.0f, (float)this.field_230709_l_ / 2.0f - (float)this.ySize / 2.0f + 10.0f, 0x404040);
        List<DietEffectsInfo.AttributeModifier> modifiers = tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = tooltip.getEffects();
        if (!(this.field_230706_i_ == null || modifiers.isEmpty() && effects.isEmpty())) {
            this.field_230706_i_.func_110434_K().func_110577_a(ICONS);
            int lowerX = this.field_230708_k_ / 2 + titleWidth / 2 + 5;
            int lowerY = this.field_230709_l_ / 2 - this.ySize / 2 + 7;
            int upperX = lowerX + 16;
            int upperY = lowerY + 16;
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)lowerX, (int)lowerY, (int)16, (int)16, (float)0.0f, (float)37.0f, (int)16, (int)16, (int)256, (int)256);
            if (mouseX >= lowerX && mouseX <= upperX && mouseY >= lowerY && mouseY <= upperY) {
                List<ITextComponent> tooltips = DietTooltip.getEffects();
                GuiUtils.drawHoveringText((MatrixStack)matrixStack, tooltips, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
            }
        }
    }

    public void renderForeground(MatrixStack matrixStack) {
        ClientPlayerEntity player;
        if (this.field_230706_i_ != null && (player = this.field_230706_i_.field_71439_g) != null) {
            DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
                int y = this.field_230709_l_ / 2 - this.ySize / 2 + 25;
                int x = this.field_230708_k_ / 2 - this.xSize / 2 + 10;
                for (IDietGroup group : DietGroups.get()) {
                    this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)group.getIcon()), x, y - 5);
                    TranslationTextComponent text = new TranslationTextComponent("groups.diet." + group.getName() + ".name");
                    this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)text, (float)(x + 20), (float)y, 0x404040);
                    this.field_230706_i_.func_110434_K().func_110577_a(ICONS);
                    Color color = diet.isActive() ? group.getColor() : Color.gray;
                    int red = color.getRed();
                    int green = color.getGreen();
                    int blue = color.getBlue();
                    int alpha = color.getAlpha();
                    int percent = (int)Math.floor(diet.getValue(group.getName()) * 100.0f);
                    String percentText = "" + percent + "%";
                    DietScreen.coloredBlit(matrixStack, x + 90, y + 2, 102, 5, 20.0f, 0.0f, 102, 5, 256, 256, red, green, blue, alpha);
                    if (percent > 0) {
                        int texWidth = percent + 1;
                        DietScreen.coloredBlit(matrixStack, x + 90, y + 2, texWidth, 5, 20.0f, 5.0f, texWidth, 5, 256, 256, red, green, blue, alpha);
                    }
                    int xPos = x + 200;
                    int yPos = y + 1;
                    this.field_230712_o_.func_238421_b_(matrixStack, percentText, (float)(xPos + 1), (float)yPos, 0);
                    this.field_230712_o_.func_238421_b_(matrixStack, percentText, (float)(xPos - 1), (float)yPos, 0);
                    this.field_230712_o_.func_238421_b_(matrixStack, percentText, (float)xPos, (float)(yPos + 1), 0);
                    this.field_230712_o_.func_238421_b_(matrixStack, percentText, (float)xPos, (float)(yPos - 1), 0);
                    this.field_230712_o_.func_238421_b_(matrixStack, percentText, (float)xPos, (float)yPos, color.getRGB());
                    y += 20;
                }
            });
        }
    }

    public void func_230446_a_(@Nonnull MatrixStack matrixStack) {
        super.func_230446_a_(matrixStack);
        if (this.field_230706_i_ != null) {
            int numGroups = DietGroups.get().size();
            this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
            int i = (this.field_230708_k_ - this.xSize) / 2;
            int j = (this.field_230709_l_ - this.ySize) / 2;
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)i, (int)j, (int)248, (int)4, (float)0.0f, (float)0.0f, (int)248, (int)4, (int)256, (int)256);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)i, (int)(j + 4), (int)248, (int)(40 + (1 + numGroups) * 18), (float)0.0f, (float)4.0f, (int)248, (int)24, (int)256, (int)256);
            AbstractGui.func_238466_a_((MatrixStack)matrixStack, (int)i, (int)(j + (1 + numGroups) * 18 + 44), (int)248, (int)4, (float)0.0f, (float)162.0f, (int)248, (int)4, (int)256, (int)256);
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
            if (this.field_230706_i_.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
                this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_230706_i_.field_71439_g));
                return true;
            }
            if (DietKeys.OPEN_GUI.func_197976_a(keyCode, scanCode)) {
                if (this.fromInventory) {
                    this.field_230706_i_.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.field_230706_i_.field_71439_g));
                } else {
                    this.func_231175_as__();
                }
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static void coloredBlit(MatrixStack matrixStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight, int red, int green, int blue, int alpha) {
        int x2 = x + width;
        int y2 = y + height;
        float minU = (uOffset + 0.0f) / (float)textureWidth;
        float maxU = (uOffset + (float)uWidth) / (float)textureWidth;
        float minV = (vOffset + 0.0f) / (float)textureHeight;
        float maxV = (vOffset + (float)vHeight) / (float)textureHeight;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y2, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x2, (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }
}

