/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import top.theillusivec4.diet.client.DietScreen;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;

public class DietTooltip {
    public static List<ITextComponent> getEffects() {
        List<DietEffectsInfo.AttributeModifier> modifiers = DietScreen.tooltip.getModifiers();
        List<DietEffectsInfo.StatusEffect> effects = DietScreen.tooltip.getEffects();
        if (modifiers.isEmpty() && effects.isEmpty()) {
            return new ArrayList<ITextComponent>();
        }
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        tooltips.add((ITextComponent)new TranslationTextComponent("tooltip.diet.effects"));
        tooltips.add(StringTextComponent.field_240750_d_);
        HashMap<Attribute, AttributeTooltip> mergedAttributes = new HashMap<Attribute, AttributeTooltip>();
        for (DietEffectsInfo.AttributeModifier attributeModifier : modifiers) {
            mergedAttributes.computeIfAbsent(attributeModifier.getAttribute(), k -> new AttributeTooltip()).merge(attributeModifier);
        }
        for (Map.Entry entry : mergedAttributes.entrySet()) {
            AttributeTooltip attributeTooltip = (AttributeTooltip)entry.getValue();
            Attribute key = (Attribute)entry.getKey();
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.added, AttributeModifier.Operation.ADDITION, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.baseMultiplier, AttributeModifier.Operation.MULTIPLY_BASE, key);
            DietTooltip.addAttributeTooltip(tooltips, attributeTooltip.totalMultiplier - 1.0f, AttributeModifier.Operation.MULTIPLY_TOTAL, key);
        }
        HashMap<Effect, Integer> mergedEffects = new HashMap<Effect, Integer>();
        for (DietEffectsInfo.StatusEffect statusEffect : effects) {
            mergedEffects.compute(statusEffect.getEffect(), (k, v) -> v == null ? statusEffect.getAmplifier() : Math.max(v, statusEffect.getAmplifier()));
        }
        for (Map.Entry entry : mergedEffects.entrySet()) {
            Effect effect1 = (Effect)entry.getKey();
            TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(effect1.func_76393_a());
            if ((Integer)entry.getValue() > 0) {
                iformattabletextcomponent = new TranslationTextComponent("potion.withAmplifier", new Object[]{iformattabletextcomponent, new TranslationTextComponent("potion.potency." + entry.getValue())});
            }
            tooltips.add((ITextComponent)iformattabletextcomponent.func_240699_a_(effect1.func_220303_e().func_220306_a()));
        }
        return tooltips;
    }

    private static void addAttributeTooltip(List<ITextComponent> tooltips, float amount, AttributeModifier.Operation operation, Attribute attribute) {
        double formattedAmount = operation != AttributeModifier.Operation.MULTIPLY_BASE && operation != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.field_233820_c_) ? (double)amount * 10.0 : (double)amount) : (double)amount * 100.0;
        if ((double)amount > 0.0) {
            tooltips.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(formattedAmount), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
        } else if ((double)amount < 0.0) {
            tooltips.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + operation.func_220371_a(), new Object[]{ItemStack.field_111284_a.format(formattedAmount *= -1.0), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.RED));
        }
    }

    private static class AttributeTooltip {
        int added = 0;
        float baseMultiplier = 0.0f;
        float totalMultiplier = 1.0f;

        private AttributeTooltip() {
        }

        void merge(DietEffectsInfo.AttributeModifier modifier) {
            float amount = modifier.getAmount();
            if (modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_BASE) {
                this.baseMultiplier += amount;
            } else if (modifier.getOperation() == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                this.totalMultiplier *= 1.0f + amount;
            } else {
                this.added = (int)((float)this.added + amount);
            }
        }
    }
}

