/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.capability;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.common.capability.DietTrackerCapability;
import top.theillusivec4.diet.common.capability.PlayerDietTracker;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.group.DietGroups;

@Mod.EventBusSubscriber(modid="diet")
public class DietCapabilityEventsListener {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            LazyOptional capability = LazyOptional.of(() -> new PlayerDietTracker((PlayerEntity)evt.getObject()));
            evt.addCapability(DietCapability.DIET_TRACKER_ID, (ICapabilityProvider)new Provider((LazyOptional<IDietTracker>)capability));
            evt.addListener(() -> ((LazyOptional)capability).invalidate());
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone evt) {
        if (evt.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            DietCapability.get((PlayerEntity)player).ifPresent(diet -> DietCapability.get(evt.getOriginal()).ifPresent(originalDiet -> {
                Map<String, Float> originalValues = originalDiet.getValues();
                for (IDietGroup group : DietGroups.get()) {
                    String id = group.getName();
                    float value = originalValues.getOrDefault(id, Float.valueOf(group.getDefaultValue())).floatValue();
                    if (evt.isWasDeath()) {
                        if (DietServerConfig.deathPenaltyMethod == DietServerConfig.DeathPenaltyMethod.RESET) {
                            value = group.getDefaultValue();
                        } else {
                            value = DietServerConfig.deathPenaltyMethod == DietServerConfig.DeathPenaltyMethod.AMOUNT ? (value -= DietServerConfig.deathPenaltyLoss) : (value *= 1.0f - DietServerConfig.deathPenaltyLoss);
                            value = Math.max(DietServerConfig.deathPenaltyMin, value);
                        }
                    }
                    diet.setValue(id, value);
                }
                diet.setActive(originalDiet.isActive());
                if (!evt.isWasDeath()) {
                    diet.setModifiers(originalDiet.getModifiers());
                }
            }));
        }
    }

    @SubscribeEvent
    public static void playerRespawned(PlayerEvent.PlayerRespawnEvent evt) {
        if (evt.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            DietCapability.get((PlayerEntity)player).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        if (evt.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            DietCapability.get((PlayerEntity)player).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerDimensionTravel(PlayerEvent.PlayerChangedDimensionEvent evt) {
        if (evt.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)evt.getPlayer();
            DietCapability.get((PlayerEntity)player).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side == LogicalSide.SERVER && evt.phase == TickEvent.Phase.END) {
            DietCapability.get(evt.player).ifPresent(IDietTracker::tick);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void finishItemUse(LivingEntityUseItemEvent.Finish evt) {
        Food food;
        ItemStack stack = evt.getItem();
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K && livingEntity instanceof PlayerEntity && (food = stack.func_77973_b().func_219967_s()) != null) {
            DietCapability.get((PlayerEntity)livingEntity).ifPresent(diet -> diet.consume(stack));
        }
    }

    private static class Provider
    implements ICapabilitySerializable<INBT> {
        private static final IDietTracker EMPTY_TRACKER = new DietTrackerCapability.EmptyDietTracker();
        final LazyOptional<IDietTracker> capability;

        public Provider(LazyOptional<IDietTracker> capability) {
            this.capability = capability;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return DietCapability.DIET_TRACKER.orEmpty(cap, this.capability);
        }

        public INBT serializeNBT() {
            return DietCapability.DIET_TRACKER.writeNBT(this.capability.orElse((Object)EMPTY_TRACKER), null);
        }

        public void deserializeNBT(INBT nbt) {
            DietCapability.DIET_TRACKER.readNBT(this.capability.orElse((Object)EMPTY_TRACKER), null, nbt);
        }
    }
}

