/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.capability;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.common.group.DietGroups;

public class DietTrackerCapability {
    public static void setup() {
        CapabilityManager.INSTANCE.register(IDietTracker.class, (Capability.IStorage)new Capability.IStorage<IDietTracker>(){

            public INBT writeNBT(Capability<IDietTracker> capability, IDietTracker instance, Direction side) {
                CompoundNBT tag = new CompoundNBT();
                Map<String, Float> values = instance.getValues();
                if (values != null) {
                    for (Map.Entry<String, Float> group : values.entrySet()) {
                        tag.func_74776_a(group.getKey(), group.getValue().floatValue());
                    }
                }
                ListNBT list = new ListNBT();
                Map<Attribute, Set<UUID>> modifiers = instance.getModifiers();
                if (modifiers != null) {
                    for (Map.Entry<Attribute, Set<UUID>> modifier : modifiers.entrySet()) {
                        CompoundNBT attributeTag = new CompoundNBT();
                        attributeTag.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)Objects.requireNonNull(modifier.getKey().getRegistryName()).toString()));
                        ListNBT uuids = new ListNBT();
                        for (UUID uuid : modifier.getValue()) {
                            uuids.add((Object)StringNBT.func_229705_a_((String)uuid.toString()));
                        }
                        attributeTag.func_218657_a("UUIDs", (INBT)uuids);
                        list.add((Object)attributeTag);
                    }
                }
                tag.func_218657_a("Modifiers", (INBT)list);
                tag.func_74757_a("Active", instance.isActive());
                return tag;
            }

            public void readNBT(Capability<IDietTracker> capability, IDietTracker instance, Direction side, INBT nbt) {
                HashMap<String, Float> groups = new HashMap<String, Float>();
                CompoundNBT tag = (CompoundNBT)nbt;
                for (IDietGroup group : DietGroups.get()) {
                    String name = group.getName();
                    float amount = tag.func_74764_b(name) ? tag.func_74760_g(name) : group.getDefaultValue();
                    groups.put(name, Float.valueOf(MathHelper.func_76131_a((float)amount, (float)0.0f, (float)1.0f)));
                }
                ListNBT list = tag.func_150295_c("Modifiers", 10);
                HashMap<Attribute, Set<UUID>> modifiers = new HashMap<Attribute, Set<UUID>>();
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT attributeTag = list.func_150305_b(i);
                    Attribute att = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeTag.func_74779_i("AttributeName")));
                    if (att == null) continue;
                    HashSet<UUID> uuids = new HashSet<UUID>();
                    ListNBT uuidList = attributeTag.func_150295_c("UUIDs", 8);
                    for (int j = 0; j < uuidList.size(); ++j) {
                        uuids.add(UUID.fromString(uuidList.func_150307_f(j)));
                    }
                    modifiers.put(att, uuids);
                }
                instance.setModifiers(modifiers);
                instance.setValues(groups);
                instance.setActive(tag.func_74767_n("Active"));
            }
        }, EmptyDietTracker::new);
    }

    public static class EmptyDietTracker
    implements IDietTracker {
        @Override
        public void tick() {
        }

        @Override
        public void consume(ItemStack stack) {
        }

        @Override
        public void consume(ItemStack stack, int healing, float saturationModifier) {
        }

        @Override
        public float getValue(String group) {
            return 0.0f;
        }

        @Override
        public void setValue(String group, float amount) {
        }

        @Override
        public Map<String, Float> getValues() {
            return new HashMap<String, Float>();
        }

        @Override
        public void setValues(Map<String, Float> groups) {
        }

        @Override
        public Map<Attribute, Set<UUID>> getModifiers() {
            return new HashMap<Attribute, Set<UUID>>();
        }

        @Override
        public void setModifiers(Map<Attribute, Set<UUID>> modifiers) {
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public PlayerEntity getPlayer() {
            return null;
        }

        @Override
        public void sync() {
        }

        @Override
        public void captureStack(ItemStack stack) {
        }

        @Override
        public ItemStack getCapturedStack() {
            return null;
        }
    }
}

