/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.capability;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.DietEvent;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.api.IDietTracker;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.effect.DietEffect;
import top.theillusivec4.diet.common.effect.DietEffects;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.network.DietNetwork;
import top.theillusivec4.diet.common.util.DietResult;

public class PlayerDietTracker
implements IDietTracker {
    private static final Map<Effect, Integer> EFFECT_DURATION = new HashMap<Effect, Integer>();
    private final PlayerEntity player;
    private final Map<String, Float> values = new HashMap<String, Float>();
    private final Map<Attribute, Set<UUID>> activeModifiers = new HashMap<Attribute, Set<UUID>>();
    private boolean active = true;
    private int prevFood;
    private ItemStack captured = ItemStack.field_190927_a;

    public PlayerDietTracker(PlayerEntity playerIn) {
        this.player = playerIn;
        this.prevFood = playerIn.func_71024_bL().func_75116_a();
        this.values.clear();
        for (IDietGroup group : DietGroups.get()) {
            String name = group.getName();
            float amount = group.getDefaultValue();
            this.values.put(name, Float.valueOf(MathHelper.func_76131_a((float)amount, (float)0.0f, (float)1.0f)));
        }
    }

    @Override
    public void tick() {
        if (this.player instanceof ServerPlayerEntity) {
            if (!this.player.func_184812_l_() && this.active) {
                int currentFood = this.player.func_71024_bL().func_75116_a();
                if (currentFood < this.prevFood && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ApplyDecay(this.player))) {
                    this.decay(this.prevFood - currentFood);
                }
                this.prevFood = currentFood;
            }
            if (this.player.field_70173_aa % 80 == 0) {
                for (Map.Entry<Attribute, Set<UUID>> entry : this.activeModifiers.entrySet()) {
                    Set<UUID> uuids = entry.getValue();
                    ModifiableAttributeInstance att = this.player.func_110148_a(entry.getKey());
                    if (att == null) continue;
                    for (UUID uuid : uuids) {
                        att.func_188479_b(uuid);
                    }
                }
                this.activeModifiers.clear();
                if (this.active) {
                    this.applyEffects();
                }
            }
        }
    }

    @Override
    public void consume(ItemStack stack, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.func_71024_bL().func_75116_a() && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ConsumeItemStack(stack, this.player)) && (result = DietApi.getInstance().get(this.player, stack, healing, saturationModifier)) != DietResult.EMPTY) {
            this.apply(result);
        }
    }

    @Override
    public void consume(ItemStack stack) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.func_71024_bL().func_75116_a() && !MinecraftForge.EVENT_BUS.post((Event)new DietEvent.ConsumeItemStack(stack, this.player)) && (result = DietApi.getInstance().get(this.player, stack)) != DietResult.EMPTY) {
            this.apply(result);
        }
    }

    @Override
    public float getValue(String group) {
        return this.values.getOrDefault(group, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setValue(String group, float amount) {
        this.values.put(group, Float.valueOf(MathHelper.func_76131_a((float)amount, (float)0.0f, (float)1.0f)));
    }

    @Override
    public Map<String, Float> getValues() {
        return ImmutableMap.copyOf(this.values);
    }

    @Override
    public void setValues(Map<String, Float> entries) {
        this.values.clear();
        this.values.putAll(entries);
    }

    @Override
    public Map<Attribute, Set<UUID>> getModifiers() {
        return ImmutableMap.copyOf(this.activeModifiers);
    }

    @Override
    public void setModifiers(Map<Attribute, Set<UUID>> modifiers) {
        this.activeModifiers.clear();
        this.activeModifiers.putAll(modifiers);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    private void applyEffects() {
        List<DietEffect> effects = DietEffects.get();
        DietEffectsInfo info = new DietEffectsInfo();
        for (DietEffect effect : effects) {
            boolean match = true;
            int multiplier = 0;
            for (DietEffect.Condition condition : effect.conditions) {
                int matches = condition.getMatches(this.player, this.values);
                if (matches == 0) {
                    match = false;
                    break;
                }
                if (condition.match != DietEffect.MatchMethod.EVERY) continue;
                multiplier += matches;
            }
            if (!match) continue;
            multiplier = Math.max(1, multiplier);
            for (DietEffect.DietAttribute attribute : effect.attributes) {
                ModifiableAttributeInstance att = this.player.func_110148_a(attribute.attribute);
                AttributeModifier mod = new AttributeModifier(effect.uuid, "Diet group effect", attribute.amount * (double)multiplier, attribute.operation);
                if (att == null || att.func_180374_a(mod)) continue;
                att.func_233769_c_(mod);
                this.activeModifiers.computeIfAbsent(attribute.attribute, k -> new HashSet()).add(effect.uuid);
                info.addModifier(attribute.attribute, mod);
            }
            for (DietEffect.DietStatusEffect statusEffect : effect.statusEffects) {
                int duration = EFFECT_DURATION.getOrDefault(statusEffect.effect, 100);
                EffectInstance instance = new EffectInstance(statusEffect.effect, duration, statusEffect.power * multiplier, true, false);
                this.player.func_195064_c(instance);
                info.addEffect(instance);
            }
        }
        if (this.player instanceof ServerPlayerEntity) {
            DietNetwork.sendEffectsInfoS2C((ServerPlayerEntity)this.player, info);
        }
    }

    private void decay(int foodDiff) {
        HashMap<String, Float> updated = new HashMap<String, Float>();
        long size = this.values.values().stream().filter(val -> val.floatValue() > 0.0f).count();
        if (size <= 0L) {
            return;
        }
        float scale = (float)foodDiff / (float)size;
        scale = (float)((double)scale * Math.pow(1.0f - DietServerConfig.decayPenaltyPerGroup, size - 1L));
        for (IDietGroup group : DietGroups.get()) {
            String name = group.getName();
            float value = this.getValue(name);
            float decay = (float)(Math.exp(value) * (double)scale * group.getDecayMultiplier() / 100.0);
            if (!(decay > 0.0f)) continue;
            value = MathHelper.func_76131_a((float)(value - decay), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            updated.put(name, Float.valueOf(value));
        }
        if (!updated.isEmpty()) {
            this.sync(updated);
        }
    }

    private void apply(IDietResult result) {
        Map<IDietGroup, Float> entries = result.get();
        HashMap<String, Float> applied = new HashMap<String, Float>();
        for (Map.Entry<IDietGroup, Float> entry : entries.entrySet()) {
            String name = entry.getKey().getName();
            float value = MathHelper.func_76131_a((float)(entry.getValue().floatValue() + this.values.get(name).floatValue()), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            applied.put(name, Float.valueOf(value));
        }
        if (!applied.isEmpty()) {
            this.sync(applied);
        }
    }

    @Override
    public void sync() {
        this.sync(this.values);
        this.sync(this.active);
    }

    private void sync(Map<String, Float> values) {
        if (this.player instanceof ServerPlayerEntity) {
            DietNetwork.sendDietS2C((ServerPlayerEntity)this.player, values);
        }
    }

    private void sync(boolean flag) {
        if (this.player instanceof ServerPlayerEntity) {
            DietNetwork.sendActivationS2C((ServerPlayerEntity)this.player, flag);
        }
    }

    @Override
    public void captureStack(ItemStack stack) {
        this.captured = stack;
    }

    @Override
    public ItemStack getCapturedStack() {
        return this.captured;
    }

    static {
        EFFECT_DURATION.put(Effects.field_76439_r, 300);
        EFFECT_DURATION.put(Effects.field_76431_k, 300);
    }
}

