/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.server.command.ModIdArgument;
import top.theillusivec4.diet.api.DietCapability;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.command.DietCsv;
import top.theillusivec4.diet.common.command.DietGroupArgument;
import top.theillusivec4.diet.common.group.DietGroups;

public class DietCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder dietCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"diet").requires(player -> player.func_197034_c(2));
        dietCommand.then(Commands.func_197057_a((String)"get").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.get((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), DietGroupArgument.getGroup((CommandContext<CommandSource>)ctx, "group"))))));
        dietCommand.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.set((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSource>)ctx, "group")))))));
        dietCommand.then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSource>)ctx, "group")))))));
        dietCommand.then(Commands.func_197057_a((String)"subtract").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.func_197056_a((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), -1.0f * FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSource>)ctx, "group")))))));
        dietCommand.then(Commands.func_197057_a((String)"reset").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> DietCommand.reset((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player")))));
        dietCommand.then(Commands.func_197057_a((String)"pause").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> DietCommand.active((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), false))));
        dietCommand.then(Commands.func_197057_a((String)"resume").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> DietCommand.active((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"), true))));
        dietCommand.then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> DietCommand.clear((CommandSource)ctx.getSource(), EntityArgument.func_197089_d((CommandContext)ctx, (String)"player")))));
        LiteralArgumentBuilder exportArg = (LiteralArgumentBuilder)Commands.func_197057_a((String)"export").executes(ctx -> DietCommand.export((CommandSource)ctx.getSource(), DietCsv.ExportMode.ALL, new String[0]));
        exportArg.then(Commands.func_197057_a((String)"group").then(Commands.func_197056_a((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.export((CommandSource)ctx.getSource(), DietGroupArgument.getGroup((CommandContext<CommandSource>)ctx, "group")))));
        exportArg.then(Commands.func_197057_a((String)"mod_id").then(Commands.func_197056_a((String)"mod_id", (ArgumentType)ModIdArgument.modIdArgument()).executes(ctx -> DietCommand.export((CommandSource)ctx.getSource(), DietCsv.ExportMode.MOD_ID, StringArgumentType.getString((CommandContext)ctx, (String)"mod_id")))));
        exportArg.then(Commands.func_197057_a((String)"uncategorized").executes(ctx -> DietCommand.export((CommandSource)ctx.getSource(), DietCsv.ExportMode.UNCATEGORIZED, new String[0])));
        dietCommand.then((ArgumentBuilder)exportArg);
        dispatcher.register(dietCommand);
    }

    private static int get(CommandSource sender, ServerPlayerEntity player, IDietGroup group) {
        DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
            float amount = diet.getValue(group.getName());
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.get.success", new Object[]{new TranslationTextComponent("groups.diet." + group.getName() + ".name"), Float.valueOf(amount * 100.0f), player.func_200200_C_()}), true);
        });
        return 1;
    }

    private static int set(CommandSource sender, ServerPlayerEntity player, float value, IDietGroup group) {
        DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
            if (diet.getValues().containsKey(group.getName())) {
                diet.setValue(group.getName(), value);
                diet.sync();
                sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.set.success", new Object[]{new TranslationTextComponent("groups.diet." + group.getName() + ".name"), Float.valueOf(value * 100.0f), player.func_200200_C_()}), true);
            }
        });
        return 1;
    }

    private static int modify(CommandSource sender, ServerPlayerEntity player, float amount, IDietGroup group) {
        if (amount != 0.0f) {
            DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
                if (diet.getValues().containsKey(group.getName())) {
                    diet.setValue(group.getName(), diet.getValue(group.getName()) + amount);
                    diet.sync();
                    String arg = amount > 0.0f ? "add" : "remove";
                    sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet." + arg + ".success", new Object[]{new TranslationTextComponent("groups.diet." + group.getName() + ".name"), Float.valueOf(amount * 100.0f), player.func_200200_C_()}), true);
                }
            });
        }
        return 1;
    }

    private static int reset(CommandSource sender, ServerPlayerEntity player) {
        DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
            for (IDietGroup group : DietGroups.get()) {
                diet.setValue(group.getName(), group.getDefaultValue());
            }
            diet.sync();
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.reset.success", new Object[]{player.func_200200_C_()}), true);
        });
        return 1;
    }

    private static int active(CommandSource sender, ServerPlayerEntity player, boolean flag) {
        DietCapability.get((PlayerEntity)player).ifPresent(diet -> {
            diet.setActive(flag);
            diet.sync();
            String arg = flag ? "resume" : "pause";
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet." + arg + ".success", new Object[]{player.func_200200_C_()}), true);
        });
        return 1;
    }

    private static int clear(CommandSource sender, ServerPlayerEntity player) {
        for (ModifiableAttributeInstance instance : player.func_233645_dx_().func_233778_a_()) {
            for (AttributeModifier attributeModifier : instance.func_225505_c_()) {
                if (!attributeModifier.func_111166_b().equals("Diet group effect")) continue;
                instance.func_188479_b(attributeModifier.func_111167_a());
            }
        }
        sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.clear.success", new Object[]{player.func_200200_C_()}), true);
        return 1;
    }

    private static int export(CommandSource sender, IDietGroup group) {
        if (sender.func_197022_f() instanceof PlayerEntity) {
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.export.started"), true);
            DietCsv.writeGroup((PlayerEntity)sender.func_197022_f(), group);
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.export.finished"), true);
        }
        return 1;
    }

    private static int export(CommandSource sender, DietCsv.ExportMode mode, String ... args) {
        if (sender.func_197022_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)sender.func_197022_f();
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.export.started"), true);
            if (mode == DietCsv.ExportMode.ALL) {
                DietCsv.write(player, "");
            } else if (mode == DietCsv.ExportMode.MOD_ID) {
                DietCsv.write(player, args[0]);
            } else if (mode == DietCsv.ExportMode.UNCATEGORIZED) {
                DietCsv.writeUncategorized(player);
            }
            sender.func_197030_a((ITextComponent)new TranslationTextComponent("commands.diet.export.finished"), true);
        }
        return 1;
    }
}

