/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.command;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.IDietGroup;

public class DietCsv {
    public static void write(PlayerEntity player, String modId) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : ForgeRegistries.ITEMS) {
            ResourceLocation rl = item.getRegistryName();
            if (rl == null || !modId.isEmpty() && !rl.func_110624_b().equals(modId)) continue;
            DietCsv.writeStack(player, item.func_190903_i(), data);
        }
        DietCsv.write(data);
    }

    public static void writeGroup(PlayerEntity player, IDietGroup group) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : group.getTag().func_230236_b_()) {
            DietCsv.writeStack(player, item.func_190903_i(), data);
        }
        DietCsv.write(data);
    }

    public static void writeUncategorized(PlayerEntity player) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!item.func_219971_r() || !DietApi.getInstance().getGroups(player, item.func_190903_i()).isEmpty()) continue;
            data.add(new String[]{Objects.requireNonNull(item.getRegistryName()).toString()});
        }
        DietCsv.write(data);
    }

    private static void writeStack(PlayerEntity player, ItemStack stack, List<String[]> data) {
        Map<IDietGroup, Float> result = DietApi.getInstance().get(player, stack).get();
        ArrayList list = Lists.newArrayList(result.entrySet());
        if (!list.isEmpty()) {
            Map.Entry entry = (Map.Entry)list.get(0);
            data.add(new String[]{Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString(), ((IDietGroup)entry.getKey()).getName(), ((Float)entry.getValue()).toString()});
            for (int i = 1; i < list.size(); ++i) {
                Map.Entry entry2 = (Map.Entry)list.get(i);
                data.add(new String[]{"", ((IDietGroup)entry2.getKey()).getName(), ((Float)entry2.getValue()).toString()});
            }
        }
    }

    private static void write(List<String[]> data) {
        Path output = Paths.get(FMLPaths.GAMEDIR.get() + "/logs/diet.csv", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String[] datum : data) {
                writer.write(DietCsv.toCsv(datum));
                writer.newLine();
            }
        }
        catch (IOException e) {
            DietMod.LOGGER.error("Error attempting to export diet information, aborting...");
            e.printStackTrace();
        }
    }

    private static String toCsv(String[] data) {
        return String.join((CharSequence)",", data);
    }

    public static enum ExportMode {
        ALL("all"),
        MOD_ID("mod_id"),
        GROUP("group"),
        UNCATEGORIZED("uncategorized");

        private final String id;

        private ExportMode(String idIn) {
            this.id = idIn;
        }

        public String getId() {
            return this.id;
        }
    }
}

