/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.config.data;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.conversion.ObjectConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.common.config.DietClientConfig;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.config.data.EffectConfigList;
import top.theillusivec4.diet.common.config.data.GroupConfigList;
import top.theillusivec4.diet.common.effect.DietEffects;
import top.theillusivec4.diet.common.group.DietGroups;

@Mod.EventBusSubscriber(modid="diet", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DietConfigReader {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static final General GENERAL;
    public static final ForgeConfigSpec GROUPS_SPEC;
    public static final Groups GROUPS;
    public static final ForgeConfigSpec EFFECTS_SPEC;
    public static final Effects EFFECTS;
    private static final String CONFIG_PREFIX = "gui.diet.config.";
    private static final ObjectConverter CONVERTER;

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, GENERAL_SPEC);
        DietConfigReader.createCustomServerConfig(GROUPS_SPEC, "groups");
        DietConfigReader.createCustomServerConfig(EFFECTS_SPEC, "effects");
    }

    @SubscribeEvent
    static void configLoad(ModConfig.Loading evt) {
        DietConfigReader.load(evt.getConfig());
    }

    @SubscribeEvent
    static void configReload(ModConfig.Reloading evt) {
        DietConfigReader.load(evt.getConfig());
    }

    public static synchronized void readGroups(CommentedConfig configData) {
        DietConfigReader.GROUPS.instance = (GroupConfigList)CONVERTER.toObject((UnmodifiableConfig)configData, GroupConfigList::new);
        DietServerConfig.groups = DietConfigReader.GROUPS.instance.groups;
        DietGroups.build(DietServerConfig.groups);
    }

    public static synchronized void readEffects(CommentedConfig configData) {
        DietConfigReader.EFFECTS.instance = (EffectConfigList)CONVERTER.toObject((UnmodifiableConfig)configData, EffectConfigList::new);
        DietServerConfig.effects = DietConfigReader.EFFECTS.instance.effects;
        DietEffects.build(DietServerConfig.effects);
    }

    public static void readServer() {
        DietServerConfig.deathPenaltyMin = ((Double)DietConfigReader.GENERAL.deathPenaltyMin.get()).floatValue();
        DietServerConfig.deathPenaltyLoss = ((Double)DietConfigReader.GENERAL.deathPenaltyLoss.get()).floatValue();
        DietServerConfig.deathPenaltyMethod = (DietServerConfig.DeathPenaltyMethod)((Object)DietConfigReader.GENERAL.deathPenaltyMethod.get());
        DietServerConfig.decayPenaltyPerGroup = ((Double)DietConfigReader.GENERAL.decayPenaltyPerGroup.get()).floatValue();
        DietServerConfig.gainPenaltyPerGroup = ((Double)DietConfigReader.GENERAL.gainPenaltyPerGroup.get()).floatValue();
        DietServerConfig.foodOverrides = new HashMap<Item, Float>();
        for (String s : (List)DietConfigReader.GENERAL.foodOverrides.get()) {
            String[] parsed = s.split(";");
            if (parsed.length == 2) {
                float quality;
                String name = parsed[0];
                try {
                    quality = Float.parseFloat(parsed[1]);
                }
                catch (NumberFormatException e) {
                    DietMod.LOGGER.error("Expected float for quality, instead got " + parsed[1]);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                if (item != null) {
                    DietServerConfig.foodOverrides.put(item, Float.valueOf(Math.max(0.0f, quality)));
                    continue;
                }
                DietMod.LOGGER.error("Could not find item " + name + " in food override");
                continue;
            }
            DietMod.LOGGER.error("Expected two arguments in food override " + s + ", instead found " + parsed.length);
        }
    }

    public static void readClient() {
        DietClientConfig.buttonX = (Integer)CLIENT.buttonX.get();
        DietClientConfig.buttonY = (Integer)CLIENT.buttonY.get();
    }

    private static void createCustomServerConfig(ForgeConfigSpec spec, String name) {
        String fileName = "diet-" + name + ".toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, spec, fileName);
        File defaults = new File(FMLPaths.GAMEDIR.get() + "/defaultconfigs/" + fileName);
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(DietMod.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                DietMod.LOGGER.error("Error creating default config for " + fileName);
            }
        }
    }

    private static synchronized void load(ModConfig config) {
        if (config.getModId().equals("diet")) {
            ForgeConfigSpec spec;
            if (config.getType() == ModConfig.Type.SERVER) {
                ForgeConfigSpec spec2 = config.getSpec();
                CommentedConfig configData = config.getConfigData();
                if (spec2 == GROUPS_SPEC) {
                    DietConfigReader.readGroups(configData);
                } else if (spec2 == EFFECTS_SPEC) {
                    DietConfigReader.readEffects(configData);
                } else if (spec2 == GENERAL_SPEC) {
                    DietConfigReader.readServer();
                }
            } else if (config.getType() == ModConfig.Type.CLIENT && (spec = config.getSpec()) == CLIENT_SPEC) {
                DietConfigReader.readClient();
            }
        }
    }

    static {
        CONVERTER = new ObjectConverter();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
        Pair generalPair = new ForgeConfigSpec.Builder().configure(General::new);
        GENERAL_SPEC = (ForgeConfigSpec)generalPair.getRight();
        GENERAL = (General)generalPair.getLeft();
        Pair groupsPair = new ForgeConfigSpec.Builder().configure(Groups::new);
        GROUPS_SPEC = (ForgeConfigSpec)groupsPair.getRight();
        GROUPS = (Groups)groupsPair.getLeft();
        Pair effectsPair = new ForgeConfigSpec.Builder().configure(Effects::new);
        EFFECTS_SPEC = (ForgeConfigSpec)effectsPair.getRight();
        EFFECTS = (Effects)effectsPair.getLeft();
    }

    public static class Effects {
        public EffectConfigList instance;

        public Effects(ForgeConfigSpec.Builder builder) {
            builder.comment("List of diet effects").define("effects", new ArrayList());
            builder.build();
        }
    }

    public static class Groups {
        public GroupConfigList instance;

        public Groups(ForgeConfigSpec.Builder builder) {
            builder.comment("List of diet groups").define("groups", new ArrayList());
            builder.build();
        }
    }

    public static class General {
        public final ForgeConfigSpec.DoubleValue deathPenaltyMin;
        public final ForgeConfigSpec.DoubleValue deathPenaltyLoss;
        public final ForgeConfigSpec.EnumValue<DietServerConfig.DeathPenaltyMethod> deathPenaltyMethod;
        public final ForgeConfigSpec.DoubleValue gainPenaltyPerGroup;
        public final ForgeConfigSpec.DoubleValue decayPenaltyPerGroup;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodOverrides;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("death_penalty");
            this.deathPenaltyMin = builder.comment("The minimum percentage that diet groups can be reduced to upon death.").translation("gui.diet.config.deathPenaltyMin").defineInRange("deathPenaltyMin", 0.0, 0.0, 1.0);
            this.deathPenaltyLoss = builder.comment("The reduction in percentage applied to all diet groups upon death.").translation("gui.diet.config.deathPenaltyLoss").defineInRange("deathPenaltyLoss", 1.0, 0.0, 1.0);
            this.deathPenaltyMethod = builder.comment("The method to apply for losses due to death penalties.\nAMOUNT = Reduce by a flat percentage amount\nPERCENT = Reduce by a percent of the current value\nRESET = Reset value to defaults").translation("gui.diet.config.deathPenaltyMethod").defineEnum("deathPenaltyMethod", (Enum)DietServerConfig.DeathPenaltyMethod.AMOUNT);
            builder.pop();
            builder.push("calculation");
            this.gainPenaltyPerGroup = builder.comment("The percent reduction in total gain for each diet group consumed at once.").translation("gui.diet.config.gainPenaltyPerGroup").defineInRange("gainPenaltyPerGroup", (double)0.15f, 0.0, 1.0);
            this.decayPenaltyPerGroup = builder.comment("The percent reduction in total decay for each diet group decayed at once.").translation("gui.diet.config.decayPenaltyPerGroup").defineInRange("decayPenaltyPerGroup", (double)0.15f, 0.0, 1.0);
            this.foodOverrides = builder.comment("List of food quality overrides for diet gain values.\nFormat: \"modid:name;quality\"").translation("gui.diet.config.foodOverrides").defineList("foodOverrides", new ArrayList(), s -> s instanceof String);
            builder.pop();
        }
    }

    public static class Client {
        private final ForgeConfigSpec.IntValue buttonX;
        private final ForgeConfigSpec.IntValue buttonY;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.buttonX = builder.comment("The x-position of the GUI button").translation("gui.diet.config.buttonX").defineInRange("buttonX", 126, -1000, 1000);
            this.buttonY = builder.comment("The y-position of the GUI button").translation("gui.diet.config.buttonY").defineInRange("buttonY", -22, -1000, 1000);
            builder.pop();
        }
    }
}

