/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.effect;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.common.config.data.EffectConfig;
import top.theillusivec4.diet.common.effect.DietEffect;

public class DietEffects {
    private static final List<DietEffect> effects = new ArrayList<DietEffect>();
    private static final String UUID_PREFIX = "ea4130c8-9065-48a6-9207-ddc020fb9fc8";

    public static void build(List<EffectConfig> configs) {
        effects.clear();
        if (configs != null) {
            int uuidSuffix = 0;
            for (EffectConfig config : configs) {
                if (config.conditions == null) {
                    DietMod.LOGGER.error("Found empty condition in diet effect, skipping...");
                    continue;
                }
                if (config.status_effects == null && config.attributes == null) {
                    DietMod.LOGGER.error("Found empty effect in diet effect, skipping...");
                    continue;
                }
                List<EffectConfig.ConditionConfig> conditionConfigs = config.conditions;
                ArrayList<EffectConfig.AttributeConfig> attributeConfigs = new ArrayList<EffectConfig.AttributeConfig>();
                ArrayList<EffectConfig.StatusEffectConfig> statusEffectConfigs = new ArrayList<EffectConfig.StatusEffectConfig>();
                if (config.attributes != null) {
                    attributeConfigs.addAll(config.attributes);
                }
                if (config.status_effects != null) {
                    statusEffectConfigs.addAll(config.status_effects);
                }
                ArrayList<DietEffect.Condition> conditions = new ArrayList<DietEffect.Condition>();
                for (EffectConfig.ConditionConfig conditionConfig : conditionConfigs) {
                    double below;
                    double above = conditionConfig.above != null ? conditionConfig.above : 0.0;
                    double d = below = conditionConfig.below != null ? conditionConfig.below : 1.0;
                    if (conditionConfig.groups == null || conditionConfig.groups.isEmpty()) {
                        DietMod.LOGGER.error("Found empty groups in conditions config, skipping...");
                        continue;
                    }
                    HashSet<String> groups = new HashSet<String>(conditionConfig.groups);
                    DietEffect.MatchMethod match = conditionConfig.match != null ? DietEffect.MatchMethod.findOrDefault(conditionConfig.match, DietEffect.MatchMethod.AVERAGE) : DietEffect.MatchMethod.AVERAGE;
                    HashSet<String> origins = conditionConfig.origins != null ? new HashSet<String>(conditionConfig.origins) : null;
                    DietEffect.OriginsMatchMethod originsMatchMethod = conditionConfig.matchOrigins != null ? DietEffect.OriginsMatchMethod.findOrDefault(conditionConfig.matchOrigins, DietEffect.OriginsMatchMethod.ANY) : DietEffect.OriginsMatchMethod.ANY;
                    HashSet<String> powers = conditionConfig.powers != null ? new HashSet<String>(conditionConfig.powers) : null;
                    DietEffect.OriginsMatchMethod powersMatchMethod = conditionConfig.matchPowers != null ? DietEffect.OriginsMatchMethod.findOrDefault(conditionConfig.matchPowers, DietEffect.OriginsMatchMethod.ANY) : DietEffect.OriginsMatchMethod.ANY;
                    conditions.add(new DietEffect.Condition(groups, match, above, below, origins, originsMatchMethod, powers, powersMatchMethod));
                }
                ArrayList<DietEffect.DietAttribute> attributes = new ArrayList<DietEffect.DietAttribute>();
                for (EffectConfig.AttributeConfig attributeConfig : attributeConfigs) {
                    if (attributeConfig.name == null || attributeConfig.amount == null || attributeConfig.operation == null) {
                        DietMod.LOGGER.error("Found missing values in attributes config, skipping...");
                        continue;
                    }
                    Attribute att = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeConfig.name));
                    if (att == null) {
                        DietMod.LOGGER.error("Found invalid attribute name " + attributeConfig.name + ", skipping...");
                        continue;
                    }
                    AttributeModifier.Operation operation = DietEffects.getOperation(attributeConfig.operation);
                    attributes.add(new DietEffect.DietAttribute(att, operation, attributeConfig.amount));
                }
                ArrayList<DietEffect.DietStatusEffect> arrayList = new ArrayList<DietEffect.DietStatusEffect>();
                for (EffectConfig.StatusEffectConfig statusEffectConfig : statusEffectConfigs) {
                    if (statusEffectConfig.name == null) {
                        DietMod.LOGGER.error("Found missing name for status effect config, skipping...");
                        continue;
                    }
                    Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(statusEffectConfig.name));
                    if (effect == null) {
                        DietMod.LOGGER.error("Found invalid status effect name " + statusEffectConfig.name + ", skipping...");
                        continue;
                    }
                    int power = statusEffectConfig.power != null ? statusEffectConfig.power : 1;
                    arrayList.add(new DietEffect.DietStatusEffect(effect, power));
                }
                UUID uuid = UUID.nameUUIDFromBytes((UUID_PREFIX + uuidSuffix).getBytes());
                ++uuidSuffix;
                effects.add(new DietEffect(uuid, attributes, arrayList, conditions));
            }
        }
    }

    public static List<DietEffect> get() {
        return ImmutableList.copyOf(effects);
    }

    private static AttributeModifier.Operation getOperation(String name) {
        if (name.equals("multiply_total")) {
            return AttributeModifier.Operation.MULTIPLY_TOTAL;
        }
        if (name.equals("multiply_base")) {
            return AttributeModifier.Operation.MULTIPLY_BASE;
        }
        return AttributeModifier.Operation.ADDITION;
    }
}

