/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class DietEffectsInfo {
    private final List<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
    private final List<StatusEffect> effects = new ArrayList<StatusEffect>();

    public void addModifier(Attribute attribute, AttributeModifier.Operation operation, float amount) {
        this.modifiers.add(new AttributeModifier(attribute, operation, amount));
    }

    public void addModifier(Attribute attribute, net.minecraft.entity.ai.attributes.AttributeModifier modifier) {
        this.modifiers.add(new AttributeModifier(attribute, modifier));
    }

    public void addEffect(Effect effect, int amplifier) {
        this.effects.add(new StatusEffect(effect, amplifier));
    }

    public void addEffect(EffectInstance effectInstance) {
        this.effects.add(new StatusEffect(effectInstance));
    }

    public List<AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    public List<StatusEffect> getEffects() {
        return this.effects;
    }

    public CompoundNBT write() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT modifiersList = new ListNBT();
        for (AttributeModifier modifier : this.modifiers) {
            CompoundNBT modifierTag = new CompoundNBT();
            modifierTag.func_74778_a("AttributeName", Objects.requireNonNull(modifier.attribute.getRegistryName()).toString());
            modifierTag.func_74776_a("Amount", modifier.amount);
            modifierTag.func_74768_a("Operation", modifier.operation.func_220371_a());
            modifiersList.add((Object)modifierTag);
        }
        ListNBT effectsList = new ListNBT();
        for (StatusEffect effect : this.effects) {
            CompoundNBT effectTag = new CompoundNBT();
            effectTag.func_74778_a("EffectName", Objects.requireNonNull(effect.effect.getRegistryName()).toString());
            effectTag.func_74768_a("Amplifier", effect.amplifier);
            effectsList.add((Object)effectTag);
        }
        tag.func_218657_a("Modifiers", (INBT)modifiersList);
        tag.func_218657_a("Effects", (INBT)effectsList);
        return tag;
    }

    public static DietEffectsInfo read(CompoundNBT tag) {
        DietEffectsInfo info = new DietEffectsInfo();
        ListNBT modifiersList = tag.func_150295_c("Modifiers", 10);
        for (int i = 0; i < modifiersList.size(); ++i) {
            CompoundNBT modifierTag = modifiersList.func_150305_b(i);
            String name = modifierTag.func_74779_i("AttributeName");
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(name));
            if (attribute == null) continue;
            float amount = modifierTag.func_74760_g("Amount");
            AttributeModifier.Operation operation = AttributeModifier.Operation.func_220372_a((int)modifierTag.func_74762_e("Operation"));
            info.addModifier(attribute, operation, amount);
        }
        ListNBT effectsList = tag.func_150295_c("Effects", 10);
        for (int i = 0; i < effectsList.size(); ++i) {
            CompoundNBT effectTag = effectsList.func_150305_b(i);
            String name = effectTag.func_74779_i("EffectName");
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(name));
            if (effect == null) continue;
            int amplifier = effectTag.func_74762_e("Amplifier");
            info.addEffect(effect, amplifier);
        }
        return info;
    }

    public static final class StatusEffect {
        private final Effect effect;
        private final int amplifier;

        private StatusEffect(Effect effectIn, int amplifierIn) {
            this.effect = effectIn;
            this.amplifier = amplifierIn;
        }

        private StatusEffect(EffectInstance effectInstance) {
            this.effect = effectInstance.func_188419_a();
            this.amplifier = effectInstance.func_76458_c();
        }

        public Effect getEffect() {
            return this.effect;
        }

        public int getAmplifier() {
            return this.amplifier;
        }
    }

    public static final class AttributeModifier {
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        private final float amount;

        private AttributeModifier(Attribute attributeIn, AttributeModifier.Operation operationIn, float amountIn) {
            this.attribute = attributeIn;
            this.operation = operationIn;
            this.amount = amountIn;
        }

        private AttributeModifier(Attribute attributeIn, net.minecraft.entity.ai.attributes.AttributeModifier modifier) {
            this.attribute = attributeIn;
            this.operation = modifier.func_220375_c();
            this.amount = (float)modifier.func_111164_d();
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public float getAmount() {
            return this.amount;
        }
    }
}

