/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.group;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.diet.DietMod;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.common.config.data.GroupConfig;
import top.theillusivec4.diet.common.group.DietGroup;

public class DietGroups {
    private static final Set<IDietGroup> groups = new TreeSet<IDietGroup>(Comparator.comparingInt(IDietGroup::getOrder).thenComparing(IDietGroup::getName));

    public static Set<IDietGroup> get() {
        return ImmutableSet.copyOf(groups);
    }

    public static void build(List<GroupConfig> configs) {
        groups.clear();
        if (configs != null) {
            for (GroupConfig config : configs) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(config.icon));
                if (item != null) {
                    int order;
                    String name = config.name;
                    float defaultValue = (float)(config.default_value != null ? config.default_value : 0.0);
                    int n = order = config.order != null ? config.order : 0;
                    DietGroup group = new DietGroup(name, item, Color.decode(config.color), defaultValue, order, config.gain_multiplier, config.decay_multiplier);
                    if (groups.add(group)) continue;
                    DietMod.LOGGER.error("Found duplicate id in diet groups config: " + name);
                    continue;
                }
                DietMod.LOGGER.error("Found unknown item in diet groups config: " + config.icon);
            }
        }
    }
}

