/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.diet.api.DietApi;
import top.theillusivec4.diet.api.IDietGroup;
import top.theillusivec4.diet.api.IDietResult;
import top.theillusivec4.diet.common.config.DietServerConfig;
import top.theillusivec4.diet.common.group.DietGroups;
import top.theillusivec4.diet.common.util.DietOverride;
import top.theillusivec4.diet.common.util.DietResult;

public class DietApiImpl
extends DietApi {
    @Override
    public Set<IDietGroup> getGroups(PlayerEntity player, ItemStack input) {
        HashSet<IDietGroup> groups = new HashSet<IDietGroup>();
        HashSet<ItemStack> processed = new HashSet<ItemStack>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayDeque<ItemStack> queue = new ArrayDeque<ItemStack>();
        queue.add(input);
        while (!queue.isEmpty()) {
            ItemStack next = (ItemStack)queue.poll();
            BiFunction<PlayerEntity, ItemStack, Triple<List<ItemStack>, Integer, Float>> func = DietOverride.get(next.func_77973_b());
            if (func != null) {
                List candidates = (List)func.apply(player, next).getLeft();
                if (candidates.isEmpty()) {
                    stacks.add(next);
                    continue;
                }
                for (ItemStack candidate : candidates) {
                    if (processed.add(candidate)) {
                        queue.add(candidate);
                        continue;
                    }
                    stacks.add(candidate);
                }
                continue;
            }
            stacks.add(next);
        }
        for (IDietGroup group : DietGroups.get()) {
            for (ItemStack stack : stacks) {
                if (!group.contains(stack)) continue;
                groups.add(group);
            }
        }
        return groups;
    }

    @Override
    public IDietResult get(PlayerEntity player, ItemStack input) {
        float saturation;
        float healing;
        Set<IDietGroup> groups = this.getGroups(player, input);
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        Item item = input.func_77973_b();
        Food food = item.func_219967_s();
        BiFunction<PlayerEntity, ItemStack, Triple<List<ItemStack>, Integer, Float>> func = DietOverride.get(item);
        Float override = DietServerConfig.foodOverrides.get(item);
        if (func != null) {
            Triple<List<ItemStack>, Integer, Float> apply = func.apply(player, input);
            healing = ((Integer)apply.getMiddle()).intValue();
            saturation = ((Float)apply.getRight()).floatValue();
        } else if (override != null) {
            healing = override.floatValue();
            saturation = 0.0f;
        } else if (food != null) {
            healing = food.func_221466_a();
            saturation = food.func_221469_b();
        } else {
            HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
            for (IDietGroup group : groups) {
                result.put(group, Float.valueOf(0.0f));
            }
            return new DietResult(result);
        }
        return new DietResult(DietApiImpl.calculate(healing, saturation, groups));
    }

    @Override
    public IDietResult get(PlayerEntity player, ItemStack input, int healing, float saturation) {
        Set<IDietGroup> groups = DietApi.getInstance().getGroups(player, input);
        if (groups.isEmpty()) {
            return DietResult.EMPTY;
        }
        return new DietResult(DietApiImpl.calculate(healing, saturation, groups));
    }

    private static Map<IDietGroup, Float> calculate(float healing, float saturation, Set<IDietGroup> groups) {
        float quality = (healing + healing * saturation) / (float)groups.size();
        float gain = quality * 0.25f / (quality + 15.0f);
        gain = (float)((double)gain * Math.pow(1.0f - DietServerConfig.gainPenaltyPerGroup, groups.size() - 1));
        HashMap<IDietGroup, Float> result = new HashMap<IDietGroup, Float>();
        for (IDietGroup group : groups) {
            float value = (float)((double)gain * group.getGainMultiplier());
            value = Math.max(0.005f, (float)Math.round(value * 200.0f) / 200.0f);
            result.put(group, Float.valueOf(value));
        }
        return result;
    }
}

