/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.diet.common.network;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import top.theillusivec4.diet.common.effect.DietEffectsInfo;
import top.theillusivec4.diet.common.network.server.SPacketActivate;
import top.theillusivec4.diet.common.network.server.SPacketDiet;
import top.theillusivec4.diet.common.network.server.SPacketEffectsInfo;

public class DietNetwork {
    private static final String PTC_VERSION = "1";
    public static SimpleChannel INSTANCE;
    private static int id;

    public static void setup() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("diet", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        DietNetwork.register(SPacketDiet.class, SPacketDiet::encode, SPacketDiet::decode, SPacketDiet::handle);
        DietNetwork.register(SPacketEffectsInfo.class, SPacketEffectsInfo::encode, SPacketEffectsInfo::decode, SPacketEffectsInfo::handle);
        DietNetwork.register(SPacketActivate.class, SPacketActivate::encode, SPacketActivate::decode, SPacketActivate::handle);
    }

    public static void sendEffectsInfoS2C(ServerPlayerEntity player, DietEffectsInfo info) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketEffectsInfo(info));
    }

    public static void sendDietS2C(ServerPlayerEntity player, Map<String, Float> groups) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketDiet(groups));
    }

    public static void sendActivationS2C(ServerPlayerEntity player, boolean flag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketActivate(flag));
    }

    private static <M> void register(Class<M> messageType, BiConsumer<M, PacketBuffer> encoder, Function<PacketBuffer, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(id++, messageType, encoder, decoder, messageConsumer);
    }

    static {
        id = 0;
    }
}

