/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.command;

import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.common.command.DietCsv;
import com.illusivesoulworks.diet.common.command.DietGroupArgument;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.platform.Services;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class DietCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder dietCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"diet").requires(player -> player.m_6761_(2));
        dietCommand.then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.get((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), DietGroupArgument.getGroup((CommandContext<CommandSourceStack>)ctx, "group"))))));
        dietCommand.then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.set((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSourceStack>)ctx, "group")))))));
        dietCommand.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSourceStack>)ctx, "group")))))));
        dietCommand.then(Commands.m_82127_((String)"subtract").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"group", (ArgumentType)DietGroupArgument.group()).then(Commands.m_82129_((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> DietCommand.modify((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), -1.0f * FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"), DietGroupArgument.getGroup((CommandContext<CommandSourceStack>)ctx, "group")))))));
        dietCommand.then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> DietCommand.reset((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
        dietCommand.then(Commands.m_82127_((String)"pause").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> DietCommand.active((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), false))));
        dietCommand.then(Commands.m_82127_((String)"resume").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> DietCommand.active((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), true))));
        dietCommand.then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> DietCommand.clear((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
        LiteralArgumentBuilder exportArg = (LiteralArgumentBuilder)Commands.m_82127_((String)"export").executes(ctx -> DietCommand.export((CommandSourceStack)ctx.getSource(), DietCsv.ExportMode.ALL, new String[0]));
        exportArg.then(Commands.m_82127_((String)"group").then(Commands.m_82129_((String)"group", (ArgumentType)DietGroupArgument.group()).executes(ctx -> DietCommand.export((CommandSourceStack)ctx.getSource(), DietGroupArgument.getGroup((CommandContext<CommandSourceStack>)ctx, "group")))));
        exportArg.then(Commands.m_82127_((String)"mod_id").then(Commands.m_82129_((String)"mod_id", Services.REGISTRY.getModIdArgument()).executes(ctx -> DietCommand.export((CommandSourceStack)ctx.getSource(), DietCsv.ExportMode.MOD_ID, StringArgumentType.getString((CommandContext)ctx, (String)"mod_id")))));
        exportArg.then(Commands.m_82127_((String)"uncategorized").executes(ctx -> DietCommand.export((CommandSourceStack)ctx.getSource(), DietCsv.ExportMode.UNCATEGORIZED, new String[0])));
        exportArg.then(Commands.m_82127_((String)"trails").executes(ctx -> DietCommand.export((CommandSourceStack)ctx.getSource(), DietCsv.ExportMode.TRAILS, new String[0])));
        dietCommand.then((ArgumentBuilder)exportArg);
        dispatcher.register(dietCommand);
    }

    private static int get(CommandSourceStack sender, ServerPlayer player, IDietGroup group) {
        Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
            float amount = diet.getValue(group.getName());
            sender.m_288197_(() -> Component.m_237110_((String)"commands.diet.get.success", (Object[])new Object[]{Component.m_237115_((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(amount * 100.0f), player.m_7755_()}), true);
        });
        return 1;
    }

    private static int set(CommandSourceStack sender, ServerPlayer player, float value, IDietGroup group) {
        Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
            if (diet.getValues().containsKey(group.getName())) {
                diet.setValue(group.getName(), value);
                diet.sync();
                sender.m_288197_(() -> Component.m_237110_((String)"commands.diet.set.success", (Object[])new Object[]{Component.m_237115_((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(value * 100.0f), player.m_7755_()}), true);
            }
        });
        return 1;
    }

    private static int modify(CommandSourceStack sender, ServerPlayer player, float amount, IDietGroup group) {
        if (amount != 0.0f) {
            Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
                if (diet.getValues().containsKey(group.getName())) {
                    diet.setValue(group.getName(), diet.getValue(group.getName()) + amount);
                    diet.sync();
                    String arg = amount > 0.0f ? "add" : "remove";
                    sender.m_288197_(() -> Component.m_237110_((String)("commands.diet." + arg + ".success"), (Object[])new Object[]{Component.m_237115_((String)("groups.diet." + group.getName() + ".name")), Float.valueOf(amount * 100.0f), player.m_7755_()}), true);
                }
            });
        }
        return 1;
    }

    private static int reset(CommandSourceStack sender, ServerPlayer player) {
        Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
            DietSuites.getSuite(player.m_9236_(), diet.getSuite()).ifPresent(suite -> {
                for (IDietGroup group : suite.getGroups()) {
                    diet.setValue(group.getName(), group.getDefaultValue());
                }
            });
            diet.sync();
            sender.m_288197_(() -> Component.m_237110_((String)"commands.diet.reset.success", (Object[])new Object[]{player.m_7755_()}), true);
        });
        return 1;
    }

    private static int active(CommandSourceStack sender, ServerPlayer player, boolean flag) {
        Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
            diet.setActive(flag);
            diet.sync();
            String arg = flag ? "resume" : "pause";
            sender.m_288197_(() -> Component.m_237110_((String)("commands.diet." + arg + ".success"), (Object[])new Object[]{player.m_7755_()}), true);
        });
        return 1;
    }

    private static int clear(CommandSourceStack sender, ServerPlayer player) {
        for (AttributeInstance instance : player.m_21204_().m_22145_()) {
            for (AttributeModifier attributeModifier : instance.m_22122_()) {
                if (!attributeModifier.m_22214_().equals("Diet group effect")) continue;
                instance.m_22120_(attributeModifier.m_22209_());
            }
        }
        sender.m_288197_(() -> Component.m_237110_((String)"commands.diet.clear.success", (Object[])new Object[]{player.m_7755_()}), true);
        return 1;
    }

    private static int export(CommandSourceStack sender, IDietGroup group) {
        if (sender.m_81373_() instanceof Player) {
            sender.m_288197_(() -> Component.m_237115_((String)"commands.diet.export.started"), true);
            DietCsv.writeGroup((Player)sender.m_81373_(), group);
            sender.m_288197_(() -> Component.m_237115_((String)"commands.diet.export.finished"), true);
        }
        return 1;
    }

    private static int export(CommandSourceStack sender, DietCsv.ExportMode mode, String ... args) {
        Entity entity = sender.m_81373_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            sender.m_288197_(() -> Component.m_237115_((String)"commands.diet.export.started"), true);
            if (mode == DietCsv.ExportMode.ALL) {
                DietCsv.write(player, "");
            } else if (mode == DietCsv.ExportMode.MOD_ID) {
                DietCsv.write(player, args[0]);
            } else if (mode == DietCsv.ExportMode.UNCATEGORIZED) {
                DietCsv.writeUncategorized(player);
            } else if (mode == DietCsv.ExportMode.TRAILS) {
                DietCsv.writeTrails(player);
            }
            sender.m_288197_(() -> Component.m_237115_((String)"commands.diet.export.finished"), true);
        }
        return 1;
    }
}

