/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.network.server;

import com.illusivesoulworks.diet.client.DietClientPacketReceiver;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.network.FriendlyByteBuf;

public record SPacketDiet(String suite, Map<String, Float> groups) {
    public static void encode(SPacketDiet msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.suite);
        for (Map.Entry<String, Float> entry : msg.groups.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.writeFloat(entry.getValue().floatValue());
        }
    }

    public static SPacketDiet decode(FriendlyByteBuf buf) {
        TreeMap<String, Float> groups = new TreeMap<String, Float>();
        String suite = buf.m_130277_();
        while (buf.isReadable()) {
            String name = buf.m_130277_();
            float value = buf.readFloat();
            groups.put(name, Float.valueOf(value));
        }
        return new SPacketDiet(suite, groups);
    }

    public static void handle(SPacketDiet msg) {
        DietClientPacketReceiver.handleDiet(msg);
    }
}

