/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.capability;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietAttribute;
import com.illusivesoulworks.diet.api.type.IDietCondition;
import com.illusivesoulworks.diet.api.type.IDietEffect;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietResult;
import com.illusivesoulworks.diet.api.type.IDietStatusEffect;
import com.illusivesoulworks.diet.api.type.IDietTracker;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.effect.DietEffect;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.common.util.DietResult;
import com.illusivesoulworks.diet.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class PlayerDietTracker
implements IDietTracker {
    private static final Map<class_1291, Integer> EFFECT_DURATION = new HashMap<class_1291, Integer>();
    private final class_1657 player;
    private final Map<String, Float> values = new HashMap<String, Float>();
    private final Map<class_1320, Set<UUID>> activeModifiers = new HashMap<class_1320, Set<UUID>>();
    private final Set<class_1792> eatenFood = new HashSet<class_1792>();
    private boolean active = true;
    private String suite = "builtin";
    private int prevFood = 0;
    private class_1799 captured = class_1799.field_8037;

    public PlayerDietTracker(class_1657 player) {
        this.player = player;
        this.initSuite();
    }

    @Override
    public void initSuite() {
        HashMap<String, Float> oldValues = new HashMap<String, Float>(this.values);
        this.values.clear();
        DietSuites.getSuite(this.player.method_37908(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float amount = oldValues.containsKey(name) ? ((Float)oldValues.get(name)).floatValue() : group.getDefaultValue();
                this.values.put(name, Float.valueOf(class_3532.method_15363((float)amount, (float)0.0f, (float)1.0f)));
            }
        });
    }

    @Override
    public void tick() {
        if (!this.player.method_37908().method_8608()) {
            if (!this.player.method_7337() && this.active) {
                int currentFood = this.player.method_7344().method_7586();
                if (currentFood < this.prevFood && !Services.EVENT.fireApplyDecayEvent(this.player)) {
                    this.decay(this.prevFood - currentFood);
                }
                this.prevFood = currentFood;
            }
            if (this.player.field_6012 % 80 == 0) {
                for (Map.Entry<class_1320, Set<UUID>> entry : this.activeModifiers.entrySet()) {
                    Set<UUID> uuids = entry.getValue();
                    class_1324 att = this.player.method_5996(entry.getKey());
                    if (att == null) continue;
                    for (UUID uuid : uuids) {
                        att.method_6200(uuid);
                    }
                }
                this.activeModifiers.clear();
                if (this.active) {
                    this.applyEffects();
                }
            }
        }
    }

    @Override
    public void consume(class_1799 stack, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.method_7344().method_7586() && !Services.EVENT.fireConsumeStackEvent(stack, this.player) && (result = DietApi.getInstance().get(this.player, stack, healing, saturationModifier)) != DietResult.EMPTY) {
            this.addEaten(stack.method_7909());
            this.apply(result);
        }
    }

    @Override
    public void consume(List<class_1799> stacks, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.method_7344().method_7586() && (result = DietApi.getInstance().get(this.player, stacks, healing, saturationModifier)) != DietResult.EMPTY) {
            this.apply(result);
        }
    }

    @Override
    public void consume(class_1799 stack) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.method_7344().method_7586() && !Services.EVENT.fireConsumeStackEvent(stack, this.player) && (result = DietApi.getInstance().get(this.player, stack)) != DietResult.EMPTY) {
            this.addEaten(stack.method_7909());
            this.apply(result);
        }
    }

    @Override
    public float getValue(String group) {
        return this.values.getOrDefault(group, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setValue(String group, float amount) {
        this.values.replace(group, Float.valueOf(class_3532.method_15363((float)amount, (float)0.0f, (float)1.0f)));
    }

    @Override
    public Map<String, Float> getValues() {
        return ImmutableMap.copyOf(this.values);
    }

    @Override
    public void setValues(Map<String, Float> entries) {
        for (Map.Entry<String, Float> entry : entries.entrySet()) {
            this.values.replace(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getSuite() {
        return this.suite;
    }

    @Override
    public void setSuite(String name) {
        if (!this.suite.equals(name)) {
            this.suite = name;
            this.initSuite();
        }
    }

    @Override
    public Map<class_1320, Set<UUID>> getModifiers() {
        return ImmutableMap.copyOf(this.activeModifiers);
    }

    @Override
    public void setModifiers(Map<class_1320, Set<UUID>> modifiers) {
        this.activeModifiers.clear();
        this.activeModifiers.putAll(modifiers);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    private void applyEffects() {
        if (Services.EVENT.fireApplyEffectEvent(this.player)) {
            return;
        }
        DietEffectsInfo info = new DietEffectsInfo();
        DietSuites.getSuite(this.player.method_37908(), this.suite).ifPresent(suite -> {
            for (IDietEffect effect : suite.getEffects()) {
                boolean match = true;
                int multiplier = 0;
                for (IDietCondition condition : effect.getConditions()) {
                    int matches = condition.getMatches(this.player, this.values);
                    if (matches == 0) {
                        match = false;
                        break;
                    }
                    if (condition.getMatchMethod() != DietEffect.MatchMethod.EVERY) continue;
                    multiplier += matches;
                }
                if (!match) continue;
                multiplier = Math.max(1, multiplier);
                for (IDietAttribute attribute : effect.getAttributes()) {
                    class_1324 att = this.player.method_5996(attribute.getAttribute());
                    class_1322 mod = new class_1322(effect.getUuid(), "Diet group effect", attribute.getBaseAmount() + (double)(multiplier - 1) * attribute.getIncrement(), attribute.getOperation());
                    if (att == null || att.method_6196(mod)) continue;
                    att.method_26837(mod);
                    this.activeModifiers.computeIfAbsent(attribute.getAttribute(), k -> new HashSet()).add(effect.getUuid());
                    info.addModifier(attribute.getAttribute(), mod);
                }
                for (IDietStatusEffect statusEffect : effect.getStatusEffects()) {
                    int duration = EFFECT_DURATION.getOrDefault(statusEffect.getEffect(), 100);
                    class_1293 instance = new class_1293(statusEffect.getEffect(), duration, statusEffect.getBasePower() + (multiplier - 1) * statusEffect.getIncrement(), true, false);
                    this.player.method_6092(instance);
                    info.addEffect(instance);
                }
            }
        });
        if (this.player instanceof class_3222) {
            Services.NETWORK.sendEffectsInfoS2C((class_3222)this.player, info);
        }
    }

    private void decay(int foodDiff) {
        HashMap<String, Float> updated = new HashMap<String, Float>();
        long size = this.values.values().stream().filter(val -> val.floatValue() > 0.0f).count();
        if (size <= 0L) {
            return;
        }
        float scale = (float)foodDiff / (float)size;
        float finalScale = scale = (float)((double)scale * Math.pow(1.0f - (float)((Integer)DietConfig.SERVER.decayPenaltyPerGroup.get()).intValue() / 100.0f, size - 1L));
        DietSuites.getSuite(this.player.method_37908(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float value = this.getValue(name);
                float decay = (float)(Math.exp(value) * (double)finalScale * group.getDecayMultiplier() / 100.0);
                if (!(decay > 0.0f)) continue;
                value = class_3532.method_15363((float)(value - decay), (float)0.0f, (float)1.0f);
                this.values.replace(name, Float.valueOf(value));
                updated.put(name, Float.valueOf(value));
            }
        });
        if (!updated.isEmpty()) {
            this.sync(this.suite, updated);
        }
    }

    private void apply(IDietResult result) {
        Map<IDietGroup, Float> entries = result.get();
        HashMap<String, Float> applied = new HashMap<String, Float>();
        for (Map.Entry<IDietGroup, Float> entry : entries.entrySet()) {
            String name = entry.getKey().getName();
            float value = class_3532.method_15363((float)(entry.getValue().floatValue() + this.values.get(name).floatValue()), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            applied.put(name, Float.valueOf(value));
        }
        if (!applied.isEmpty()) {
            this.sync(this.suite, applied);
        }
    }

    @Override
    public void sync() {
        this.sync(this.suite, this.values);
        this.sync(this.active);
        this.sync(this.eatenFood);
    }

    private void sync(Set<class_1792> values) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            Services.NETWORK.sendEatenS2C(serverPlayer, values);
        }
    }

    private void sync(String suite, Map<String, Float> values) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            Services.NETWORK.sendDietS2C(serverPlayer, suite, values);
        }
    }

    private void sync(boolean flag) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            Services.NETWORK.sendActivationS2C(serverPlayer, flag);
        }
    }

    @Override
    public void captureStack(class_1799 stack) {
        this.captured = stack;
    }

    @Override
    public class_1799 getCapturedStack() {
        return this.captured;
    }

    @Override
    public void addEaten(class_1792 item) {
        this.eatenFood.add(item);
        this.sync(Sets.newHashSet((Object[])new class_1792[]{item}));
    }

    @Override
    public Set<class_1792> getEaten() {
        return this.eatenFood;
    }

    @Override
    public void setEaten(Set<class_1792> foods) {
        this.eatenFood.clear();
        this.eatenFood.addAll(foods);
    }

    @Override
    public void save(class_2487 tag) {
        Map<String, Float> values = this.getValues();
        if (values != null) {
            for (Map.Entry<String, Float> group : values.entrySet()) {
                tag.method_10548(group.getKey(), group.getValue().floatValue());
            }
        }
        class_2499 list = new class_2499();
        Map<class_1320, Set<UUID>> modifiers = this.getModifiers();
        if (modifiers != null) {
            for (Map.Entry<class_1320, Set<UUID>> modifier : modifiers.entrySet()) {
                class_2487 attributeTag = new class_2487();
                attributeTag.method_10566("AttributeName", (class_2520)class_2519.method_23256((String)Objects.requireNonNull(Services.REGISTRY.getAttributeKey(modifier.getKey())).toString()));
                class_2499 uuids = new class_2499();
                for (UUID uuid : modifier.getValue()) {
                    uuids.add((Object)class_2519.method_23256((String)uuid.toString()));
                }
                attributeTag.method_10566("UUIDs", (class_2520)uuids);
                list.add((Object)attributeTag);
            }
        }
        tag.method_10566("Modifiers", (class_2520)list);
        list = new class_2499();
        Set<class_1792> eaten = this.getEaten();
        if (eaten != null) {
            for (class_1792 item : eaten) {
                class_2960 rl = Services.REGISTRY.getItemKey(item);
                if (rl == null) continue;
                list.add((Object)class_2519.method_23256((String)rl.toString()));
            }
        }
        tag.method_10566("Eaten", (class_2520)list);
        tag.method_10556("Active", this.isActive());
    }

    @Override
    public void load(class_2487 tag) {
        HashMap<String, Float> groups = new HashMap<String, Float>();
        DietSuites.getSuite(this.player.method_37908(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float amount = tag.method_10545(name) ? tag.method_10583(name) : group.getDefaultValue();
                groups.put(name, Float.valueOf(class_3532.method_15363((float)amount, (float)0.0f, (float)1.0f)));
            }
        });
        class_2499 list = tag.method_10554("Modifiers", 10);
        HashMap<class_1320, Set<UUID>> modifiers = new HashMap<class_1320, Set<UUID>>();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 attributeTag = list.method_10602(i);
            class_1320 att = Services.REGISTRY.getAttribute(new class_2960(attributeTag.method_10558("AttributeName"))).orElse(null);
            if (att == null) continue;
            HashSet<UUID> uuids = new HashSet<UUID>();
            class_2499 uuidList = attributeTag.method_10554("UUIDs", 8);
            for (int j = 0; j < uuidList.size(); ++j) {
                uuids.add(UUID.fromString(uuidList.method_10608(j)));
            }
            modifiers.put(att, uuids);
        }
        list = tag.method_10554("Eaten", 8);
        HashSet<class_1792> eaten = new HashSet<class_1792>();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.method_10608(i);
            class_2960 rl = new class_2960(s);
            Services.REGISTRY.getItem(rl).ifPresent(eaten::add);
        }
        this.setEaten(eaten);
        this.setModifiers(modifiers);
        this.setValues(groups);
        this.setActive(!tag.method_10545("Active") || tag.method_10577("Active"));
    }

    @Override
    public void copy(class_1657 oldPlayer, boolean wasDeath) {
        Services.CAPABILITY.get(this.player).ifPresent(diet -> Services.CAPABILITY.get(oldPlayer).ifPresent(originalDiet -> {
            Map<String, Float> originalValues = originalDiet.getValues();
            DietSuites.getSuite(this.player.method_37908(), this.suite).ifPresent(suite -> {
                for (IDietGroup group : suite.getGroups()) {
                    float originalValue;
                    String id = group.getName();
                    float newValue = originalValue = originalValues.getOrDefault(id, Float.valueOf(group.getDefaultValue())).floatValue();
                    if (wasDeath) {
                        if (DietConfig.SERVER.deathPenaltyMethod.get() == DietConfig.DeathPenaltyMethod.RESET) {
                            newValue = group.getDefaultValue();
                        } else {
                            float loss = (float)((Integer)DietConfig.SERVER.deathPenaltyLoss.get()).intValue() / 100.0f;
                            newValue = DietConfig.SERVER.deathPenaltyMethod.get() == DietConfig.DeathPenaltyMethod.AMOUNT ? (newValue -= loss) : (newValue *= 1.0f - loss);
                            newValue = Math.min(originalValue, Math.max(newValue, (float)((Integer)DietConfig.SERVER.deathPenaltyMin.get()).intValue() / 100.0f));
                        }
                    }
                    diet.setValue(id, newValue);
                }
            });
            diet.setActive(originalDiet.isActive());
            if (!wasDeath) {
                diet.setModifiers(originalDiet.getModifiers());
            }
        }));
    }

    static {
        EFFECT_DURATION.put(class_1294.field_5925, 300);
        EFFECT_DURATION.put(class_1294.field_5916, 300);
    }
}

